/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.math.BigInteger;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmByte;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt16;
import org.apache.olingo.commons.core.edm.primitivetype.EdmInt64;
import org.apache.olingo.commons.core.edm.primitivetype.EdmSByte;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.apache.olingo.commons.core.edm.primitivetype.Uint7;

public final class EdmInt32
extends SingletonPrimitiveType {
    private static final EdmInt32 INSTANCE = new EdmInt32();

    public static EdmInt32 getInstance() {
        return INSTANCE;
    }

    public boolean isCompatible(EdmPrimitiveType primitiveType) {
        return primitiveType instanceof Uint7 || primitiveType instanceof EdmByte || primitiveType instanceof EdmSByte || primitiveType instanceof EdmInt16 || primitiveType instanceof EdmInt32;
    }

    public Class<?> getDefaultType() {
        return Integer.class;
    }

    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Integer valueInteger;
        try {
            valueInteger = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)", (Exception)e);
        }
        try {
            return (T)EdmInt64.convertNumber((Number)valueInteger, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_UNCONVERTIBLE_TO_VALUE_TYPE.addContent(value, returnType), e");
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType), e");
        }
    }

    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
            return value.toString();
        }
        if (value instanceof Long) {
            if ((Long)value >= Integer.MIN_VALUE && (Long)value <= Integer.MAX_VALUE) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_ILLEGAL_CONTENT.addContent(value)");
        }
        if (value instanceof BigInteger) {
            if (((BigInteger)value).bitLength() < 32) {
                return value.toString();
            }
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_ILLEGAL_CONTENT.addContent(value)");
        }
        throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass())");
    }
}

