/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDateTimeOffset;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public final class EdmDate
extends SingletonPrimitiveType {
    private static final Pattern PATTERN = Pattern.compile("(-?\\p{Digit}{4,})-(\\p{Digit}{2})-(\\p{Digit}{2})");
    private static final EdmDate INSTANCE = new EdmDate();

    public static EdmDate getInstance() {
        return INSTANCE;
    }

    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        Calendar dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dateTimeValue.clear();
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)");
        }
        dateTimeValue.set(Integer.parseInt(matcher.group(1)), Byte.parseByte(matcher.group(2)) - 1, Byte.parseByte(matcher.group(3)));
        try {
            return (T)EdmDateTimeOffset.convertDateTime((Calendar)dateTimeValue, (int)0, returnType);
        }
        catch (IllegalArgumentException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value)", (Exception)e);
        }
        catch (ClassCastException e) {
            throw new EdmPrimitiveTypeException("EdmPrimitiveTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType)", (Exception)e);
        }
    }

    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        Calendar dateTimeValue = EdmDateTimeOffset.createDateTime(value);
        StringBuilder result = new StringBuilder(10);
        int year = dateTimeValue.get(1);
        if (year < 0 || year >= 10000) {
            result.append(year);
        } else {
            EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)(year / 100 % 100));
            EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)(year % 100));
        }
        result.append('-');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)(dateTimeValue.get(2) + 1));
        result.append('-');
        EdmDateTimeOffset.appendTwoDigits((StringBuilder)result, (int)dateTimeValue.get(5));
        return result.toString();
    }
}

