/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotationsTarget;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.EdmElementImpl;

public abstract class AbstractEdmNavigationProperty
extends EdmElementImpl
implements EdmNavigationProperty {
    private EdmEntityType typeImpl;
    private EdmNavigationProperty partnerNavigationProperty;

    public AbstractEdmNavigationProperty(Edm edm, String name) {
        super(edm, name);
    }

    protected abstract FullQualifiedName getTypeFQN();

    public EdmEntityType getType() {
        if (this.typeImpl == null) {
            this.typeImpl = this.edm.getEntityType(this.getTypeFQN());
            if (this.typeImpl == null) {
                throw new EdmException("Cannot find type with name: " + this.getTypeFQN());
            }
        }
        return this.typeImpl;
    }

    protected abstract String internatGetPartner();

    public EdmNavigationProperty getPartner() {
        String partner;
        if (this.partnerNavigationProperty == null && (partner = this.internatGetPartner()) != null) {
            String[] split;
            EdmEntityType type = this.getType();
            EdmNavigationProperty property = null;
            for (String element : split = partner.split("/")) {
                property = type.getNavigationProperty(element);
                if (property == null) {
                    throw new EdmException("Cannot find navigation property with name: " + element + " at type " + type.getName());
                }
                type = property.getType();
            }
            this.partnerNavigationProperty = property;
        }
        return this.partnerNavigationProperty;
    }

    public abstract String getReferencingPropertyName(String var1);

    public EdmAnnotationsTarget.TargetType getAnnotationsTargetType() {
        return EdmAnnotationsTarget.TargetType.NavigationProperty;
    }

    public String getAnnotationsTargetPath() {
        return this.getName();
    }
}

