/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmServiceMetadata;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.ActionMapKey;
import org.apache.olingo.commons.core.edm.FunctionMapKey;

public abstract class AbstractEdm
implements Edm {
    protected Map<String, EdmSchema> schemas;
    protected List<EdmSchema> schemaList;
    private final Map<FullQualifiedName, EdmEntityContainer> entityContainers = new HashMap();
    private final Map<FullQualifiedName, EdmEnumType> enumTypes = new HashMap();
    private final Map<FullQualifiedName, EdmTypeDefinition> typeDefinitions = new HashMap();
    private final Map<FullQualifiedName, EdmEntityType> entityTypes = new HashMap();
    private final Map<FullQualifiedName, EdmComplexType> complexTypes = new HashMap();
    private final Map<FullQualifiedName, EdmAction> unboundActions = new HashMap();
    private final Map<FullQualifiedName, List<EdmFunction>> unboundFunctionsByName = new HashMap();
    private final Map<FunctionMapKey, EdmFunction> unboundFunctionsByKey = new HashMap();
    private final Map<ActionMapKey, EdmAction> boundActions = new HashMap();
    private final Map<FunctionMapKey, EdmFunction> boundFunctions = new HashMap();
    private final Map<FullQualifiedName, EdmTerm> terms = new HashMap();
    private final Map<FullQualifiedName, EdmAnnotations> annotationGroups = new HashMap();
    private final Map<FullQualifiedName, List<EdmAnnotation>> annotations = new HashMap();
    private EdmServiceMetadata serviceMetadata;
    private Map<String, String> aliasToNamespaceInfo;

    public List<EdmSchema> getSchemas() {
        this.initSchemas();
        return this.schemaList;
    }

    public EdmSchema getSchema(String namespace) {
        this.initSchemas();
        EdmSchema schema = (EdmSchema)this.schemas.get(namespace);
        if (schema == null) {
            if (this.aliasToNamespaceInfo == null) {
                this.aliasToNamespaceInfo = this.createAliasToNamespaceInfo();
            }
            schema = (EdmSchema)this.schemas.get(this.aliasToNamespaceInfo.get(namespace));
        }
        return schema;
    }

    private void initSchemas() {
        if (this.schemas == null) {
            this.schemas = this.createSchemas();
            if (this.schemas != null) {
                this.schemaList = Collections.unmodifiableList(new ArrayList(this.schemas.values()));
                this.aliasToNamespaceInfo = new HashMap();
                for (EdmSchema schema : this.schemas.values()) {
                    EdmEntityContainer entityContainer;
                    List localFunctions;
                    List localActions;
                    List localEntityTypes;
                    List localComplexTypes;
                    List localTypeDefinitions;
                    List localEnumTypes;
                    String namespace = schema.getNamespace();
                    this.schemas.put(namespace, schema);
                    if (schema.getAlias() != null) {
                        this.aliasToNamespaceInfo.put(schema.getAlias(), namespace);
                    }
                    if ((localEnumTypes = schema.getEnumTypes()) != null) {
                        for (EdmEnumType enumType : localEnumTypes) {
                            this.enumTypes.put(new FullQualifiedName(namespace, enumType.getName()), enumType);
                        }
                    }
                    if ((localTypeDefinitions = schema.getTypeDefinitions()) != null) {
                        for (EdmTypeDefinition typeDef : localTypeDefinitions) {
                            this.typeDefinitions.put(new FullQualifiedName(namespace, typeDef.getName()), typeDef);
                        }
                    }
                    if ((localComplexTypes = schema.getComplexTypes()) != null) {
                        for (EdmComplexType complexType : localComplexTypes) {
                            this.complexTypes.put(new FullQualifiedName(namespace, complexType.getName()), complexType);
                        }
                    }
                    if ((localEntityTypes = schema.getEntityTypes()) != null) {
                        for (EdmEntityType entityType : localEntityTypes) {
                            this.entityTypes.put(new FullQualifiedName(namespace, entityType.getName()), entityType);
                        }
                    }
                    if ((localActions = schema.getActions()) != null) {
                        for (EdmAction action : localActions) {
                            FullQualifiedName name = new FullQualifiedName(namespace, action.getName());
                            if (action.isBound()) {
                                ActionMapKey key = new ActionMapKey(name, action.getBindingParameterTypeFqn(), action.isBindingParameterTypeCollection());
                                this.boundActions.put(key, action);
                                continue;
                            }
                            this.unboundActions.put(name, action);
                        }
                    }
                    if ((localFunctions = schema.getFunctions()) != null) {
                        for (EdmFunction function : localFunctions) {
                            FullQualifiedName name = new FullQualifiedName(namespace, function.getName());
                            FunctionMapKey key = new FunctionMapKey(name, function.getBindingParameterTypeFqn(), function.isBindingParameterTypeCollection(), function.getParameterNames());
                            if (function.isBound()) {
                                this.boundFunctions.put(key, function);
                                continue;
                            }
                            if (!this.unboundFunctionsByName.containsKey(name)) {
                                this.unboundFunctionsByName.put(name, new ArrayList());
                            }
                            ((List)this.unboundFunctionsByName.get(name)).add(function);
                            this.unboundFunctionsByKey.put(key, function);
                        }
                    }
                    if ((entityContainer = schema.getEntityContainer()) == null) continue;
                    this.entityContainers.put(new FullQualifiedName(namespace, entityContainer.getName()), entityContainer);
                    if (this.entityContainers.containsKey(null)) continue;
                    this.entityContainers.put(null, entityContainer);
                }
            }
        }
    }

    public EdmEntityContainer getEntityContainer(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmEntityContainer container = (EdmEntityContainer)this.entityContainers.get(fqn);
        if (container == null && (container = this.createEntityContainer(fqn)) != null) {
            this.entityContainers.put(fqn, container);
            if (fqn == null) {
                this.entityContainers.put(new FullQualifiedName(container.getNamespace(), container.getName()), container);
            }
        }
        return container;
    }

    public EdmEnumType getEnumType(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmEnumType enumType = (EdmEnumType)this.enumTypes.get(fqn);
        if (enumType == null && (enumType = this.createEnumType(fqn)) != null) {
            this.enumTypes.put(fqn, enumType);
        }
        return enumType;
    }

    public EdmTypeDefinition getTypeDefinition(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmTypeDefinition typeDefinition = (EdmTypeDefinition)this.typeDefinitions.get(fqn);
        if (typeDefinition == null && (typeDefinition = this.createTypeDefinition(fqn)) != null) {
            this.typeDefinitions.put(fqn, typeDefinition);
        }
        return typeDefinition;
    }

    public EdmEntityType getEntityType(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmEntityType entityType = (EdmEntityType)this.entityTypes.get(fqn);
        if (entityType == null && (entityType = this.createEntityType(fqn)) != null) {
            this.entityTypes.put(fqn, entityType);
        }
        return entityType;
    }

    public EdmComplexType getComplexType(FullQualifiedName namespaceOrAliasFQN) {
        FullQualifiedName fqn = this.resolvePossibleAlias(namespaceOrAliasFQN);
        EdmComplexType complexType = (EdmComplexType)this.complexTypes.get(fqn);
        if (complexType == null && (complexType = this.createComplexType(fqn)) != null) {
            this.complexTypes.put(fqn, complexType);
        }
        return complexType;
    }

    public EdmAction getUnboundAction(FullQualifiedName actionName) {
        EdmAction action = (EdmAction)this.unboundActions.get(actionName);
        if (action == null && (action = this.createUnboundAction(this.resolvePossibleAlias(actionName))) != null) {
            this.unboundActions.put(actionName, action);
        }
        return action;
    }

    public EdmAction getBoundAction(FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        FullQualifiedName bindingParameterTypeFqn;
        FullQualifiedName actionFqn = this.resolvePossibleAlias(actionName);
        ActionMapKey key = new ActionMapKey(actionFqn, bindingParameterTypeFqn = this.resolvePossibleAlias(bindingParameterTypeName), isBindingParameterCollection);
        EdmAction action = (EdmAction)this.boundActions.get(key);
        if (action == null && (action = this.createBoundAction(actionFqn, bindingParameterTypeFqn, isBindingParameterCollection)) != null) {
            this.boundActions.put(key, action);
        }
        return action;
    }

    public List<EdmFunction> getUnboundFunctions(FullQualifiedName functionName) {
        FullQualifiedName functionFqn = this.resolvePossibleAlias(functionName);
        List functions = (List)this.unboundFunctionsByName.get(functionFqn);
        if (functions == null && (functions = this.createUnboundFunctions(functionFqn)) != null) {
            this.unboundFunctionsByName.put(functionFqn, functions);
            for (EdmFunction unbound : functions) {
                FunctionMapKey key = new FunctionMapKey(new FullQualifiedName(unbound.getNamespace(), unbound.getName()), unbound.getBindingParameterTypeFqn(), unbound.isBindingParameterTypeCollection(), unbound.getParameterNames());
                this.unboundFunctionsByKey.put(key, unbound);
            }
        }
        return functions;
    }

    public EdmFunction getUnboundFunction(FullQualifiedName functionName, List<String> parameterNames) {
        FullQualifiedName functionFqn = this.resolvePossibleAlias(functionName);
        FunctionMapKey key = new FunctionMapKey(functionFqn, null, null, parameterNames);
        EdmFunction function = (EdmFunction)this.unboundFunctionsByKey.get(key);
        if (function == null && (function = this.createUnboundFunction(functionFqn, parameterNames)) != null) {
            this.unboundFunctionsByKey.put(key, function);
        }
        return function;
    }

    public EdmFunction getBoundFunction(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        FullQualifiedName bindingParameterTypeFqn;
        FullQualifiedName functionFqn = this.resolvePossibleAlias(functionName);
        FunctionMapKey key = new FunctionMapKey(functionFqn, bindingParameterTypeFqn = this.resolvePossibleAlias(bindingParameterTypeName), isBindingParameterCollection, parameterNames);
        EdmFunction function = (EdmFunction)this.boundFunctions.get(key);
        if (function == null && (function = this.createBoundFunction(functionFqn, bindingParameterTypeFqn, isBindingParameterCollection, parameterNames)) != null) {
            this.boundFunctions.put(key, function);
        }
        return function;
    }

    public EdmTerm getTerm(FullQualifiedName termName) {
        FullQualifiedName fqn = this.resolvePossibleAlias(termName);
        EdmTerm term = (EdmTerm)this.terms.get(fqn);
        if (term == null && (term = this.createTerm(fqn)) != null) {
            this.terms.put(fqn, term);
        }
        return term;
    }

    public EdmAnnotations getAnnotationGroup(FullQualifiedName targetName) {
        EdmAnnotations _annotations = (EdmAnnotations)this.annotationGroups.get(targetName);
        if (_annotations == null && (_annotations = this.createAnnotationGroup(targetName)) != null) {
            this.annotationGroups.put(targetName, _annotations);
        }
        return _annotations;
    }

    public List<EdmAnnotation> getAnnotations(FullQualifiedName annotatableName) {
        FullQualifiedName fqn = this.resolvePossibleAlias(annotatableName);
        List _annotations = (List)this.annotations.get(fqn);
        if (_annotations == null && (_annotations = this.createAnnotations(fqn)) != null) {
            this.annotations.put(fqn, _annotations);
        }
        return _annotations;
    }

    public EdmAnnotation getAnnotation(FullQualifiedName annotatableName, EdmTerm term) {
        List _annotations = this.getAnnotations(annotatableName);
        EdmAnnotation result = null;
        if (_annotations != null) {
            for (EdmAnnotation annotation : _annotations) {
                if (!term.getFullQualifiedName().equals((Object)annotation.getTerm().getFullQualifiedName())) continue;
                result = annotation;
            }
        }
        return result;
    }

    public EdmServiceMetadata getServiceMetadata() {
        if (this.serviceMetadata == null) {
            this.serviceMetadata = this.createServiceMetadata();
        }
        return this.serviceMetadata;
    }

    private FullQualifiedName resolvePossibleAlias(FullQualifiedName namespaceOrAliasFQN) {
        if (this.aliasToNamespaceInfo == null) {
            this.aliasToNamespaceInfo = this.createAliasToNamespaceInfo();
        }
        FullQualifiedName finalFQN = null;
        if (namespaceOrAliasFQN != null) {
            String namespace = (String)this.aliasToNamespaceInfo.get(namespaceOrAliasFQN.getNamespace());
            finalFQN = namespace == null ? namespaceOrAliasFQN : new FullQualifiedName(namespace, namespaceOrAliasFQN.getName());
        }
        return finalFQN;
    }

    protected abstract Map<String, EdmSchema> createSchemas();

    protected abstract Map<String, String> createAliasToNamespaceInfo();

    protected abstract EdmEntityContainer createEntityContainer(FullQualifiedName var1);

    protected abstract EdmEnumType createEnumType(FullQualifiedName var1);

    protected abstract EdmTypeDefinition createTypeDefinition(FullQualifiedName var1);

    protected abstract EdmEntityType createEntityType(FullQualifiedName var1);

    protected abstract EdmComplexType createComplexType(FullQualifiedName var1);

    protected abstract EdmAction createUnboundAction(FullQualifiedName var1);

    protected abstract List<EdmFunction> createUnboundFunctions(FullQualifiedName var1);

    protected abstract EdmFunction createUnboundFunction(FullQualifiedName var1, List<String> var2);

    protected abstract EdmAction createBoundAction(FullQualifiedName var1, FullQualifiedName var2, Boolean var3);

    protected abstract EdmFunction createBoundFunction(FullQualifiedName var1, FullQualifiedName var2, Boolean var3, List<String> var4);

    protected abstract EdmServiceMetadata createServiceMetadata();

    protected abstract EdmTerm createTerm(FullQualifiedName var1);

    protected abstract EdmAnnotations createAnnotationGroup(FullQualifiedName var1);

    protected abstract List<EdmAnnotation> createAnnotations(FullQualifiedName var1);
}

