/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain.v4;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.commons.api.domain.ODataCollectionValue;
import org.apache.olingo.commons.api.domain.ODataComplexValue;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.domain.v4.ODataEnumValue;
import org.apache.olingo.commons.api.domain.v4.ODataLinkedComplexValue;
import org.apache.olingo.commons.api.domain.v4.ODataProperty;
import org.apache.olingo.commons.api.domain.v4.ODataValuable;
import org.apache.olingo.commons.api.domain.v4.ODataValue;

public class ODataValuableImpl
implements ODataValuable {
    private final ODataValue value;

    public ODataValuableImpl(ODataValue value) {
        this.value = value;
    }

    public ODataValue getValue() {
        return this.value;
    }

    public boolean hasNullValue() {
        return this.value == null;
    }

    public boolean hasPrimitiveValue() {
        return !this.hasNullValue() && this.value.isPrimitive();
    }

    public ODataPrimitiveValue getPrimitiveValue() {
        return this.hasPrimitiveValue() ? this.value.asPrimitive() : null;
    }

    public boolean hasCollectionValue() {
        return !this.hasNullValue() && this.value.isCollection();
    }

    public ODataCollectionValue<ODataValue> getCollectionValue() {
        return this.hasCollectionValue() ? this.getValue().asCollection() : null;
    }

    public boolean hasComplexValue() {
        return !this.hasNullValue() && this.value.isComplex();
    }

    public ODataComplexValue<ODataProperty> getComplexValue() {
        return this.hasComplexValue() ? this.getValue().asComplex() : null;
    }

    public ODataLinkedComplexValue getLinkedComplexValue() {
        return this.hasComplexValue() ? this.getValue().asLinkedComplex() : null;
    }

    public boolean hasEnumValue() {
        return !this.hasNullValue() && this.getValue().isEnum();
    }

    public ODataEnumValue getEnumValue() {
        return this.hasEnumValue() ? this.getValue().asEnum() : null;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

