/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain.v3;

import java.net.URI;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataCollectionValue;
import org.apache.olingo.commons.api.domain.ODataComplexValue;
import org.apache.olingo.commons.api.domain.ODataLink;
import org.apache.olingo.commons.api.domain.ODataLinkType;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.domain.ODataValue;
import org.apache.olingo.commons.api.domain.v3.ODataEntity;
import org.apache.olingo.commons.api.domain.v3.ODataEntitySet;
import org.apache.olingo.commons.api.domain.v3.ODataObjectFactory;
import org.apache.olingo.commons.api.domain.v3.ODataProperty;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.domain.AbstractODataObjectFactory;
import org.apache.olingo.commons.core.domain.v3.ODataCollectionValueImpl;
import org.apache.olingo.commons.core.domain.v3.ODataComplexValueImpl;
import org.apache.olingo.commons.core.domain.v3.ODataEntityImpl;
import org.apache.olingo.commons.core.domain.v3.ODataEntitySetImpl;
import org.apache.olingo.commons.core.domain.v3.ODataPrimitiveValueImpl;
import org.apache.olingo.commons.core.domain.v3.ODataPropertyImpl;

public class ODataObjectFactoryImpl
extends AbstractODataObjectFactory
implements ODataObjectFactory {
    public ODataObjectFactoryImpl(ODataServiceVersion version) {
        super(version);
    }

    public ODataEntitySet newEntitySet() {
        return new ODataEntitySetImpl();
    }

    public ODataEntitySet newEntitySet(URI next) {
        return new ODataEntitySetImpl(next);
    }

    public ODataEntity newEntity(FullQualifiedName typeName) {
        return new ODataEntityImpl(typeName);
    }

    public ODataEntity newEntity(FullQualifiedName typeName, URI link) {
        ODataEntityImpl result = new ODataEntityImpl(typeName);
        result.setLink(link);
        return result;
    }

    public ODataLink newAssociationLink(URI link) {
        return new ODataLink.Builder().setVersion(this.version).setURI(link).setType(ODataLinkType.ASSOCIATION).build();
    }

    public ODataLink newEntityNavigationLink(String name, URI link) {
        return new ODataLink.Builder().setVersion(this.version).setURI(link).setType(ODataLinkType.ENTITY_NAVIGATION).setTitle(name).build();
    }

    public ODataLink newEntitySetNavigationLink(String name, URI link) {
        return new ODataLink.Builder().setVersion(this.version).setURI(link).setType(ODataLinkType.ENTITY_SET_NAVIGATION).setTitle(name).build();
    }

    public ODataLink newAssociationLink(String name, URI link) {
        return new ODataLink.Builder().setVersion(this.version).setURI(link).setType(ODataLinkType.ASSOCIATION).setTitle(name).build();
    }

    public ODataLink newMediaEditLink(String name, URI link) {
        return new ODataLink.Builder().setVersion(this.version).setURI(link).setType(ODataLinkType.MEDIA_EDIT).setTitle(name).build();
    }

    public ODataPrimitiveValue.Builder newPrimitiveValueBuilder() {
        return new ODataPrimitiveValueImpl.BuilderImpl(this.version);
    }

    public ODataComplexValue<ODataProperty> newComplexValue(String typeName) {
        return new ODataComplexValueImpl(typeName);
    }

    public ODataCollectionValue<ODataValue> newCollectionValue(String typeName) {
        return new ODataCollectionValueImpl(typeName);
    }

    public ODataProperty newPrimitiveProperty(String name, ODataPrimitiveValue value) {
        return new ODataPropertyImpl(name, (ODataValue)value);
    }

    public ODataProperty newComplexProperty(String name, ODataComplexValue<? extends CommonODataProperty> value) {
        return new ODataPropertyImpl(name, value);
    }

    public ODataProperty newCollectionProperty(String name, ODataCollectionValue<? extends ODataValue> value) {
        return new ODataPropertyImpl(name, value);
    }
}

