/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.domain;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataPrimitiveValue;
import org.apache.olingo.commons.api.domain.ODataValue;

public abstract class AbstractODataProperty
implements CommonODataProperty {
    private final String name;
    private final ODataValue value;

    public AbstractODataProperty(String name, ODataValue value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public ODataValue getValue() {
        return this.value;
    }

    public boolean hasNullValue() {
        return this.value == null || this.value.isPrimitive() && this.value.asPrimitive().toValue() == null;
    }

    public boolean hasPrimitiveValue() {
        return !this.hasNullValue() && this.value.isPrimitive();
    }

    public ODataPrimitiveValue getPrimitiveValue() {
        return this.hasPrimitiveValue() ? this.value.asPrimitive() : null;
    }

    public boolean hasComplexValue() {
        return !this.hasNullValue() && this.value.isComplex();
    }

    public boolean hasCollectionValue() {
        return !this.hasNullValue() && this.value.isCollection();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

