/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.olingo.commons.api.data.Annotatable;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.LinkedComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.geo.Geospatial;

public abstract class AbstractValuable
implements Valuable,
Annotatable {
    private ValueType valueType = null;
    private Object value = null;
    private final List<Annotation> annotations = new ArrayList();

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isPrimitive() {
        return this.valueType == ValueType.PRIMITIVE;
    }

    public boolean isGeospatial() {
        return this.valueType == ValueType.GEOSPATIAL;
    }

    public boolean isEnum() {
        return this.valueType == ValueType.ENUM;
    }

    public boolean isComplex() {
        return this.valueType == ValueType.COMPLEX;
    }

    public boolean isLinkedComplex() {
        return this.valueType == ValueType.LINKED_COMPLEX;
    }

    public boolean isCollection() {
        return this.valueType != null && this.valueType != this.valueType.getBaseType();
    }

    public Object asPrimitive() {
        return this.isPrimitive() ? this.value : null;
    }

    public Geospatial asGeospatial() {
        return this.isGeospatial() ? (Geospatial)this.value : null;
    }

    public Object asEnum() {
        return this.isEnum() ? this.value : null;
    }

    public List<Property> asComplex() {
        return this.isComplex() ? (List)this.value : null;
    }

    public LinkedComplexValue asLinkedComplex() {
        return this.isLinkedComplex() ? (LinkedComplexValue)this.value : null;
    }

    public List<?> asCollection() {
        return this.isCollection() ? (List)this.value : null;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(ValueType valueType, Object value) {
        this.valueType = valueType;
        this.value = value;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

