/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ContentType;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ODataFormat {
    JSON_NO_METADATA,
    JSON,
    JSON_FULL_METADATA,
    XML(ContentType.APPLICATION_XML),
    ATOM(ContentType.APPLICATION_ATOM_XML),
    APPLICATION_XML(ContentType.APPLICATION_XML),
    APPLICATION_ATOM_XML(ContentType.APPLICATION_ATOM_XML),
    APPLICATION_XHTML_XML(ContentType.APPLICATION_XHTML_XML),
    APPLICATION_SVG_XML(ContentType.APPLICATION_SVG_XML),
    APPLICATION_JSON(ContentType.APPLICATION_JSON),
    APPLICATION_FORM_URLENCODED(ContentType.APPLICATION_FORM_URLENCODED),
    MULTIPART_FORM_DATA(ContentType.MULTIPART_FORM_DATA),
    APPLICATION_OCTET_STREAM(ContentType.APPLICATION_OCTET_STREAM),
    TEXT_PLAIN(ContentType.TEXT_PLAIN),
    TEXT_XML(ContentType.TEXT_XML),
    TEXT_HTML(ContentType.TEXT_HTML);

    private static final String JSON_METADATA_PARAMETER_V3 = "odata";
    private static final String JSON_METADATA_PARAMETER_V4 = "odata.metadata";
    private static final Map<ODataServiceVersion, Map<ODataFormat, ContentType>> FORMAT_PER_VERSION;
    private final ContentType contentType;

    private ODataFormat(ContentType contentType) {
        this.contentType = contentType;
    }

    private ODataFormat() {
        this.contentType = null;
    }

    public ContentType getContentType(ODataServiceVersion version) {
        if (version.ordinal() < ODataServiceVersion.V30.ordinal()) {
            throw new IllegalArgumentException("Unsupported version " + version);
        }
        return this.contentType == null ? (ContentType)((Map)FORMAT_PER_VERSION.get(version)).get(this) : this.contentType;
    }

    public String toString() {
        if (this.contentType == null) {
            throw new UnsupportedOperationException();
        }
        return this.contentType.toContentTypeString();
    }

    public static ODataFormat fromContentType(ContentType contentType) {
        if (contentType == null) {
            return null;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_ATOM_XML) || contentType.isCompatible(ContentType.APPLICATION_ATOM_SVC)) {
            return ATOM;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_XML)) {
            return XML;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            String jsonVariant = (String)contentType.getParameters().get("odata");
            if (jsonVariant != null) {
                for (ODataFormat candidate : ((Map)FORMAT_PER_VERSION.get(ODataServiceVersion.V30)).keySet()) {
                    if (!((String)((ContentType)((Map)FORMAT_PER_VERSION.get(ODataServiceVersion.V30)).get(candidate)).getParameters().get("odata")).equals(jsonVariant)) continue;
                    return candidate;
                }
            }
            if ((jsonVariant = (String)contentType.getParameters().get("odata.metadata")) != null) {
                for (ODataFormat candidate : ((Map)FORMAT_PER_VERSION.get(ODataServiceVersion.V40)).keySet()) {
                    if (!((String)((ContentType)((Map)FORMAT_PER_VERSION.get(ODataServiceVersion.V40)).get(candidate)).getParameters().get("odata.metadata")).equals(jsonVariant)) continue;
                    return candidate;
                }
            }
            return JSON;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_OCTET_STREAM)) {
            return APPLICATION_OCTET_STREAM;
        }
        if (contentType.isCompatible(ContentType.TEXT_PLAIN)) {
            return TEXT_PLAIN;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_XHTML_XML)) {
            return APPLICATION_XHTML_XML;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_SVG_XML)) {
            return APPLICATION_SVG_XML;
        }
        if (contentType.isCompatible(ContentType.APPLICATION_FORM_URLENCODED)) {
            return APPLICATION_FORM_URLENCODED;
        }
        if (contentType.isCompatible(ContentType.MULTIPART_FORM_DATA)) {
            return MULTIPART_FORM_DATA;
        }
        if (contentType.isCompatible(ContentType.TEXT_XML)) {
            return TEXT_XML;
        }
        if (contentType.isCompatible(ContentType.TEXT_HTML)) {
            return TEXT_HTML;
        }
        throw new IllegalArgumentException("Unsupported content Type: " + contentType);
    }

    public static ODataFormat fromString(String contentType) {
        return contentType == null ? null : ODataFormat.fromContentType((ContentType)ContentType.parse((String)contentType));
    }

    static {
        FORMAT_PER_VERSION = new HashMap();
        HashMap<ODataFormat, ContentType> v3 = new HashMap<ODataFormat, ContentType>();
        v3.put(JSON_NO_METADATA, ContentType.create((ContentType)ContentType.APPLICATION_JSON, (String[])new String[]{"odata=nometadata"}));
        v3.put(JSON, ContentType.create((ContentType)ContentType.APPLICATION_JSON, (String[])new String[]{"odata=minimalmetadata"}));
        v3.put(JSON_FULL_METADATA, ContentType.create((ContentType)ContentType.APPLICATION_JSON, (String[])new String[]{"odata=fullmetadata"}));
        FORMAT_PER_VERSION.put(ODataServiceVersion.V30, v3);
        HashMap<ODataFormat, ContentType> v4 = new HashMap<ODataFormat, ContentType>();
        v4.put(JSON_NO_METADATA, ContentType.create((ContentType)ContentType.APPLICATION_JSON, (String[])new String[]{"odata.metadata=none"}));
        v4.put(JSON, ContentType.create((ContentType)ContentType.APPLICATION_JSON, (String[])new String[]{"odata.metadata=minimal"}));
        v4.put(JSON_FULL_METADATA, ContentType.create((ContentType)ContentType.APPLICATION_JSON, (String[])new String[]{"odata.metadata=full"}));
        FORMAT_PER_VERSION.put(ODataServiceVersion.V40, v4);
    }
}

