/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.olingo.commons.api.format.TypeUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ContentType {
    public static final ContentType APPLICATION_XML = ContentType.create((String)"application/xml");
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create((String)"application/atom+xml");
    public static final ContentType APPLICATION_ATOM_XML_ENTRY = ContentType.create((ContentType)APPLICATION_ATOM_XML, (String[])new String[]{"type=entry"});
    public static final ContentType APPLICATION_ATOM_XML_FEED = ContentType.create((ContentType)APPLICATION_ATOM_XML, (String[])new String[]{"type=feed"});
    public static final ContentType APPLICATION_ATOM_SVC = ContentType.create((String)"application/atomsvc+xml");
    public static final ContentType APPLICATION_JSON = ContentType.create((String)"application/json");
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create((String)"application/octet-stream");
    public static final ContentType TEXT_PLAIN = ContentType.create((String)"text/plain");
    public static final ContentType MULTIPART_MIXED = ContentType.create((String)"multipart/mixed");
    public static final ContentType APPLICATION_XHTML_XML = ContentType.create((String)"application/xhtml+xml");
    public static final ContentType APPLICATION_SVG_XML = ContentType.create((String)"application/svg+xml");
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create((String)"application/x-www-form-urlencoded");
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create((String)"multipart/form-data");
    public static final ContentType TEXT_XML = ContentType.create((String)"text/xml");
    public static final ContentType TEXT_HTML = ContentType.create((String)"text/html");
    public static final String PARAMETER_CHARSET_UTF8 = "charset=utf-8";
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    private ContentType(String type, String subtype, Map<String, String> parameters) {
        this.type = this.validateType(type);
        this.subtype = this.validateType(subtype);
        if (parameters == null) {
            this.parameters = Collections.emptyMap();
        } else {
            this.parameters = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
            this.parameters.putAll(parameters);
        }
    }

    private String validateType(String type) {
        if (type == null || type.isEmpty() || "*".equals(type)) {
            throw new IllegalArgumentException("Illegal type '" + type + "'.");
        }
        int len = type.length();
        for (int i = 0; i < len; ++i) {
            if (type.charAt(i) != ' ') continue;
            throw new IllegalArgumentException("Illegal whitespace found for type '" + type + "'.");
        }
        return type;
    }

    public static boolean isParseable(String format) {
        try {
            return ContentType.create((String)format) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static ContentType create(String format, String ... parameters) {
        ContentType ct = ContentType.parse((String)format);
        for (String p : parameters) {
            String[] keyvalue = p.split("=");
            ct.parameters.put(keyvalue[0], keyvalue[1]);
        }
        return ct;
    }

    public static ContentType create(ContentType contentType, String ... parameters) {
        ContentType ct = new ContentType(contentType.type, contentType.subtype, contentType.parameters);
        for (String p : parameters) {
            String[] keyvalue = p.split("=");
            ct.parameters.put(keyvalue[0], keyvalue[1]);
        }
        return ct;
    }

    public static ContentType create(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Parameter format MUST NOT be NULL.");
        }
        ArrayList typeSubtype = new ArrayList();
        HashMap parameters = new HashMap();
        ContentType.parse((String)format, typeSubtype, parameters);
        return new ContentType((String)typeSubtype.get(0), (String)typeSubtype.get(1), parameters);
    }

    public static ContentType parse(String format) {
        try {
            return ContentType.create((String)format);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parse(String format, List<String> typeSubtype, Map<String, String> parameters) {
        String params;
        String[] typesAndParameters = format.split(";", 2);
        String types = typesAndParameters[0];
        String string = params = typesAndParameters.length > 1 ? typesAndParameters[1] : null;
        if (!types.contains("/")) throw new IllegalArgumentException("No separator '/' was found in format '" + format + "'.");
        String[] tokens = types.split("/");
        if (tokens.length != 2) throw new IllegalArgumentException("Too many '/' in format '" + format + "'.");
        if (tokens[0] == null || tokens[0].isEmpty()) {
            throw new IllegalArgumentException("No type found in format '" + format + "'.");
        }
        if (tokens[1] == null || tokens[1].isEmpty()) {
            throw new IllegalArgumentException("No subtype found in format '" + format + "'.");
        }
        typeSubtype.add(tokens[0]);
        typeSubtype.add(tokens[1]);
        TypeUtil.parseParameters((String)params, parameters);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        Boolean compatible = this.isEqualWithoutParameters(obj);
        if (compatible == null) {
            ContentType other = (ContentType)obj;
            if (this.parameters == null) {
                if (other.parameters != null) {
                    return false;
                }
            } else if (this.parameters.size() == other.parameters.size()) {
                Iterator entries = this.parameters.entrySet().iterator();
                Iterator otherEntries = other.parameters.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry e = entries.next();
                    Map.Entry oe = otherEntries.next();
                    if (!ContentType.areEqual((String)((String)e.getKey()), (String)((String)oe.getKey()))) {
                        return false;
                    }
                    if (ContentType.areEqual((String)((String)e.getValue()), (String)((String)oe.getValue()))) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return compatible;
    }

    public boolean isCompatible(ContentType obj) {
        Boolean compatible = this.isEqualWithoutParameters((Object)obj);
        return compatible == null || compatible != false;
    }

    private Boolean isEqualWithoutParameters(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (this.subtype == null ? other.subtype != null : !this.subtype.equalsIgnoreCase(other.subtype)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equalsIgnoreCase(other.type)) {
            return false;
        }
        return null;
    }

    private static boolean areEqual(String first, String second) {
        return first == null && second == null || first.equalsIgnoreCase(second);
    }

    public String toContentTypeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type).append("/").append(this.subtype);
        for (String key : this.parameters.keySet()) {
            sb.append(";").append(key).append("=").append((String)this.parameters.get(key));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toContentTypeString();
    }
}

