/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm.constants;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ODataServiceVersion {
    V10("1.0"),
    V20("2.0"),
    V30("3.0"),
    V40("4.0");

    private static final Map<NamespaceKey, String> V30_NAMESPACES;
    private static final Map<NamespaceKey, String> V40_NAMESPACES;
    private static final Map<JsonKey, String> V30_JSON;
    private static final Map<JsonKey, String> V40_JSON;
    private static final Pattern DATASERVICEVERSIONPATTERN;
    private final String version;

    public static boolean validateDataServiceVersion(String version) {
        Matcher matcher = DATASERVICEVERSIONPATTERN.matcher(version);
        if (matcher.matches()) {
            String possibleDataServiceVersion = matcher.group(1);
            return V10.toString().equals(possibleDataServiceVersion) || V20.toString().equals(possibleDataServiceVersion) || V30.toString().equals(possibleDataServiceVersion) || V40.toString().equals(possibleDataServiceVersion);
        }
        throw new IllegalArgumentException(version);
    }

    public static boolean isBiggerThan(String actual, String comparedTo) {
        double other;
        if (!ODataServiceVersion.validateDataServiceVersion((String)comparedTo) || !ODataServiceVersion.validateDataServiceVersion((String)actual)) {
            throw new IllegalArgumentException("Illegal arguments: " + comparedTo + " and " + actual);
        }
        double me = Double.parseDouble(ODataServiceVersion.extractDataServiceVersionString((String)actual));
        return me > (other = Double.parseDouble(ODataServiceVersion.extractDataServiceVersionString((String)comparedTo)));
    }

    private static String extractDataServiceVersionString(String rawDataServiceVersion) {
        if (rawDataServiceVersion != null) {
            String[] pattern = rawDataServiceVersion.split(";");
            return pattern[0];
        }
        return null;
    }

    private ODataServiceVersion(String version) {
        this.version = version;
    }

    public String getNamespace(NamespaceKey key) {
        return this == V10 || this == V20 ? null : (this == V30 ? (String)V30_NAMESPACES.get(key) : (String)V40_NAMESPACES.get(key));
    }

    public String getJsonName(JsonKey key) {
        return this == V10 || this == V20 ? null : (this == V30 ? (String)V30_JSON.get(key) : (String)V40_JSON.get(key));
    }

    public String toString() {
        return this.version;
    }

    static {
        V30_NAMESPACES = new /* Unavailable Anonymous Inner Class!! */;
        V40_NAMESPACES = new /* Unavailable Anonymous Inner Class!! */;
        V30_JSON = new /* Unavailable Anonymous Inner Class!! */;
        V40_JSON = new /* Unavailable Anonymous Inner Class!! */;
        DATASERVICEVERSIONPATTERN = Pattern.compile("(\\p{Digit}+\\.\\p{Digit}+)(:?;.*)?");
    }
}

