/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.edm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

/*
 * Exception performing whole class analysis ignored.
 */
public enum EdmPrimitiveTypeKind {
    Binary,
    Boolean,
    Byte,
    SByte,
    Date(new ODataServiceVersion[]{ODataServiceVersion.V40}),
    DateTime(new ODataServiceVersion[]{ODataServiceVersion.V30}),
    DateTimeOffset,
    Time(new ODataServiceVersion[]{ODataServiceVersion.V30}),
    TimeOfDay(new ODataServiceVersion[]{ODataServiceVersion.V40}),
    Duration(new ODataServiceVersion[]{ODataServiceVersion.V40}),
    Decimal,
    Single,
    Double,
    Guid,
    Int16,
    Int32,
    Int64,
    String,
    Stream,
    Geography,
    GeographyPoint,
    GeographyLineString,
    GeographyPolygon,
    GeographyMultiPoint,
    GeographyMultiLineString,
    GeographyMultiPolygon,
    GeographyCollection,
    Geometry,
    GeometryPoint,
    GeometryLineString,
    GeometryPolygon,
    GeometryMultiPoint,
    GeometryMultiLineString,
    GeometryMultiPolygon,
    GeometryCollection;

    private final List<ODataServiceVersion> versions;

    private EdmPrimitiveTypeKind() {
        this.versions = Collections.unmodifiableList(Arrays.asList(ODataServiceVersion.V30, ODataServiceVersion.V40));
    }

    private EdmPrimitiveTypeKind(ODataServiceVersion[] versions) {
        this.versions = Collections.unmodifiableList(Arrays.asList((Object[])versions.clone()));
    }

    public List<ODataServiceVersion> getSupportedVersions() {
        return this.versions;
    }

    public boolean isGeospatial() {
        return this.name().startsWith("Geo");
    }

    public FullQualifiedName getFullQualifiedName() {
        return new FullQualifiedName("Edm", this.toString());
    }

    public static EdmPrimitiveTypeKind valueOf(ODataServiceVersion version, String name) {
        EdmPrimitiveTypeKind kind = EdmPrimitiveTypeKind.valueOf((String)name);
        if (!kind.versions.contains(version)) {
            throw new IllegalArgumentException(kind + " not allowed in " + version);
        }
        return kind;
    }

    public static EdmPrimitiveTypeKind valueOfFQN(ODataServiceVersion version, FullQualifiedName fqn) {
        return EdmPrimitiveTypeKind.valueOfFQN((ODataServiceVersion)version, (String)fqn.toString());
    }

    public static EdmPrimitiveTypeKind valueOfFQN(ODataServiceVersion version, String fqn) {
        if (version == null) {
            throw new IllegalArgumentException("No OData protocol version provided");
        }
        if (!fqn.startsWith("Edm.")) {
            throw new IllegalArgumentException(fqn + " does not look like an Edm primitive type");
        }
        EdmPrimitiveTypeKind kind = EdmPrimitiveTypeKind.valueOf((String)fqn.substring(4));
        if (!kind.versions.contains(version)) {
            throw new IllegalArgumentException(kind + " not allowed in " + version);
        }
        return kind;
    }
}

