/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.data;

import org.apache.olingo.commons.api.data.GeoUtils;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;

public final class GeoUtils {
    public static Geospatial.Dimension getDimension(EdmPrimitiveTypeKind type) {
        Geospatial.Dimension dimension;
        switch (1.$SwitchMap$org$apache$olingo$commons$api$edm$EdmPrimitiveTypeKind[type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                dimension = Geospatial.Dimension.GEOGRAPHY;
                break;
            }
            default: {
                dimension = Geospatial.Dimension.GEOMETRY;
            }
        }
        return dimension;
    }

    public static EdmPrimitiveTypeKind getType(Geospatial.Dimension dimension, String elementName) {
        EdmPrimitiveTypeKind type = null;
        if ("Point".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyPoint : EdmPrimitiveTypeKind.GeometryPoint;
        } else if ("MultiPoint".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyMultiPoint : EdmPrimitiveTypeKind.GeometryMultiPoint;
        } else if ("LineString".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyLineString : EdmPrimitiveTypeKind.GeometryLineString;
        } else if ("MultiCurve".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyMultiLineString : EdmPrimitiveTypeKind.GeometryMultiLineString;
        } else if ("Polygon".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyPolygon : EdmPrimitiveTypeKind.GeometryPolygon;
        } else if ("MultiSurface".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyMultiPolygon : EdmPrimitiveTypeKind.GeometryMultiPolygon;
        } else if ("MultiGeometry".equals(elementName) || "geometryMembers".equals(elementName)) {
            type = dimension == Geospatial.Dimension.GEOGRAPHY ? EdmPrimitiveTypeKind.GeographyCollection : EdmPrimitiveTypeKind.GeometryCollection;
        }
        return type;
    }

    private GeoUtils() {
    }
}

