/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.uri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.olingo.client.api.Configuration;
import org.apache.olingo.client.api.uri.CommonURIBuilder;
import org.apache.olingo.client.api.uri.QueryOption;
import org.apache.olingo.client.api.uri.SegmentType;
import org.apache.olingo.client.api.uri.URIFilter;
import org.apache.olingo.client.core.uri.AbstractURIBuilder;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractURIBuilder<UB extends CommonURIBuilder<?>>
implements CommonURIBuilder<UB> {
    protected static final Logger LOG = LoggerFactory.getLogger(CommonURIBuilder.class);
    private final ODataServiceVersion version;
    private final Configuration configuration;
    protected final List<Segment> segments = new ArrayList();
    protected final Map<String, String> queryOptions = new LinkedHashMap();
    protected final Map<String, String> parameters = new LinkedHashMap();

    protected AbstractURIBuilder(ODataServiceVersion version, Configuration configuration, String serviceRoot) {
        this.version = version;
        this.configuration = configuration;
        this.segments.add(new Segment(SegmentType.SERVICEROOT, serviceRoot));
    }

    protected abstract UB getThis();

    public UB addQueryOption(QueryOption option, String value) {
        return (UB)this.addQueryOption(option.toString(), value);
    }

    public UB addQueryOption(String option, String value) {
        StringBuilder builder = new StringBuilder();
        if (this.queryOptions.containsKey(option)) {
            builder.append((String)this.queryOptions.get(option)).append(',');
        }
        builder.append(value);
        this.queryOptions.put(option, builder.toString());
        return (UB)this.getThis();
    }

    public UB addParameterAlias(String alias, String exp) {
        this.parameters.put(alias, exp);
        return (UB)this.getThis();
    }

    public UB appendEntitySetSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.ENTITYSET, segmentValue));
        return (UB)this.getThis();
    }

    public UB appendKeySegment(Object val) {
        String segValue = URIUtils.escape((ODataServiceVersion)this.version, (Object)val);
        this.segments.add(this.configuration.isKeyAsSegment() ? new Segment(SegmentType.KEY_AS_SEGMENT, segValue) : new Segment(SegmentType.KEY, "(" + segValue + ")"));
        return (UB)this.getThis();
    }

    protected abstract String noKeysWrapper();

    public UB appendKeySegment(Map<String, Object> segmentValues) {
        if (!this.configuration.isKeyAsSegment()) {
            String key = this.buildMultiKeySegment(segmentValues, true);
            if (StringUtils.isEmpty((CharSequence)key)) {
                this.segments.add(new Segment(SegmentType.KEY, this.noKeysWrapper()));
            } else {
                this.segments.add(new Segment(SegmentType.KEY, key));
            }
        }
        return (UB)this.getThis();
    }

    public UB appendPropertySegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.PROPERTY, segmentValue));
        return (UB)this.getThis();
    }

    public UB appendNavigationSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.NAVIGATION, segmentValue));
        return (UB)this.getThis();
    }

    public UB appendDerivedEntityTypeSegment(String segmentValue) {
        this.segments.add(new Segment(SegmentType.DERIVED_ENTITY_TYPE, segmentValue));
        return (UB)this.getThis();
    }

    public UB appendValueSegment() {
        this.segments.add(new Segment(SegmentType.VALUE, SegmentType.VALUE.getValue()));
        return (UB)this.getThis();
    }

    public UB appendOperationCallSegment(String operation) {
        this.segments.add(new Segment(this.segments.size() == 1 ? SegmentType.UNBOUND_OPERATION : SegmentType.BOUND_OPERATION, operation));
        return (UB)this.getThis();
    }

    public UB appendMetadataSegment() {
        this.segments.add(new Segment(SegmentType.METADATA, SegmentType.METADATA.getValue()));
        return (UB)this.getThis();
    }

    public UB appendBatchSegment() {
        this.segments.add(new Segment(SegmentType.BATCH, SegmentType.BATCH.getValue()));
        return (UB)this.getThis();
    }

    public UB count() {
        this.segments.add(new Segment(SegmentType.ROOT_QUERY_OPTION, "$" + QueryOption.COUNT.toString()));
        return (UB)this.getThis();
    }

    public UB expand(String ... expandItems) {
        return (UB)this.addQueryOption(QueryOption.EXPAND, StringUtils.join((Object[])expandItems, (String)","));
    }

    public UB format(String format) {
        return (UB)this.addQueryOption(QueryOption.FORMAT, format);
    }

    public UB filter(URIFilter filter) {
        CommonURIBuilder result;
        try {
            result = this.filter(URLDecoder.decode(filter.build(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            result = this.filter(filter.build());
        }
        return (UB)result;
    }

    public UB filter(String filter) {
        return (UB)this.addQueryOption(QueryOption.FILTER, filter);
    }

    public UB select(String ... selectItems) {
        return (UB)this.addQueryOption(QueryOption.SELECT, StringUtils.join((Object[])selectItems, (String)","));
    }

    public UB orderBy(String order) {
        return (UB)this.addQueryOption(QueryOption.ORDERBY, order);
    }

    public UB top(int top) {
        return (UB)this.addQueryOption(QueryOption.TOP, String.valueOf(top));
    }

    public UB skip(int skip) {
        return (UB)this.addQueryOption(QueryOption.SKIP, String.valueOf(skip));
    }

    public UB skipToken(String skipToken) {
        return (UB)this.addQueryOption(QueryOption.SKIPTOKEN, skipToken);
    }

    protected abstract char getBoundOperationSeparator();

    protected abstract String getOperationInvokeMarker();

    public URI build() {
        StringBuilder segmentsBuilder = new StringBuilder();
        for (Segment seg : this.segments) {
            if (segmentsBuilder.length() > 0 && seg.getType() != SegmentType.KEY) {
                switch (1.$SwitchMap$org$apache$olingo$client$api$uri$SegmentType[seg.getType().ordinal()]) {
                    case 1: {
                        segmentsBuilder.append(this.getBoundOperationSeparator());
                        break;
                    }
                    default: {
                        if (segmentsBuilder.length() <= 0 || segmentsBuilder.charAt(segmentsBuilder.length() - 1) == '/') break;
                        segmentsBuilder.append('/');
                    }
                }
            }
            if (seg.getType() == SegmentType.ENTITY) {
                segmentsBuilder.append(seg.getType().getValue());
            } else {
                segmentsBuilder.append(seg.getValue());
            }
            if (seg.getType() != SegmentType.BOUND_OPERATION && seg.getType() != SegmentType.UNBOUND_OPERATION) continue;
            segmentsBuilder.append(this.getOperationInvokeMarker());
        }
        try {
            StringBuilder sb = segmentsBuilder;
            if (this.queryOptions.size() + this.parameters.size() > 0) {
                sb.append("?");
                LinkedList<BasicNameValuePair> list1 = new LinkedList<BasicNameValuePair>();
                for (Map.Entry option : this.queryOptions.entrySet()) {
                    list1.add(new BasicNameValuePair("$" + (String)option.getKey(), (String)option.getValue()));
                }
                for (Map.Entry parameter : this.parameters.entrySet()) {
                    list1.add(new BasicNameValuePair("@" + (String)parameter.getKey(), (String)parameter.getValue()));
                }
                String queryStr = URLEncodedUtils.format(list1, (String)"UTF-8");
                sb.append(queryStr);
            }
            return URI.create(sb.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not build valid URI", e);
        }
    }

    public String toString() {
        return this.build().toASCIIString();
    }

    protected String buildMultiKeySegment(Map<String, Object> segmentValues, boolean escape) {
        if (segmentValues == null || segmentValues.isEmpty()) {
            return "";
        }
        StringBuilder keyBuilder = new StringBuilder().append('(');
        for (Map.Entry<String, Object> entry : segmentValues.entrySet()) {
            keyBuilder.append(entry.getKey()).append('=').append(escape ? URIUtils.escape((ODataServiceVersion)this.version, (Object)entry.getValue()) : entry.getValue());
            keyBuilder.append(',');
        }
        keyBuilder.deleteCharAt(keyBuilder.length() - 1).append(')');
        return keyBuilder.toString();
    }
}

