/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization.v3;

import java.io.InputStream;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.domain.v3.ODataLinkCollection;
import org.apache.olingo.client.api.serialization.v3.ODataReader;
import org.apache.olingo.client.api.v3.ODataClient;
import org.apache.olingo.client.core.serialization.AbstractODataReader;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.data.v3.LinkCollection;
import org.apache.olingo.commons.api.domain.v3.ODataEntity;
import org.apache.olingo.commons.api.domain.v3.ODataEntitySet;
import org.apache.olingo.commons.api.domain.v3.ODataProperty;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataDeserializerException;

public class ODataReaderImpl
extends AbstractODataReader
implements ODataReader {
    public ODataReaderImpl(ODataClient client) {
        super((CommonODataClient)client);
    }

    public ODataEntitySet readEntitySet(InputStream input, ODataFormat format) throws ODataDeserializerException {
        return ((ODataClient)this.client).getBinder().getODataEntitySet(this.client.getDeserializer(format).toEntitySet(input));
    }

    public ODataEntity readEntity(InputStream input, ODataFormat format) throws ODataDeserializerException {
        return ((ODataClient)this.client).getBinder().getODataEntity(this.client.getDeserializer(format).toEntity(input));
    }

    public ODataProperty readProperty(InputStream input, ODataFormat format) throws ODataDeserializerException {
        return ((ODataClient)this.client).getBinder().getODataProperty(this.client.getDeserializer(format).toProperty(input));
    }

    public ODataLinkCollection readLinks(InputStream input, ODataFormat format) throws ODataDeserializerException {
        return ((ODataClient)this.client).getBinder().getLinkCollection((LinkCollection)((ODataClient)this.client).getDeserializer(format).toLinkCollection(input).getPayload());
    }

    public <T> ResWrap<T> read(InputStream src, String format, Class<T> reference) throws ODataDeserializerException {
        if (ODataLinkCollection.class.isAssignableFrom(reference)) {
            ResWrap container = ((ODataClient)this.client).getDeserializer(ODataFormat.fromString((String)format)).toLinkCollection(src);
            return new ResWrap(container.getContextURL(), container.getMetadataETag(), (Object)((ODataClient)this.client).getBinder().getLinkCollection((LinkCollection)container.getPayload()));
        }
        return super.read(src, format, reference);
    }
}

