/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4.annotation;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.olingo.client.api.edm.xml.v4.annotation.DynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.AbstractDynamicAnnotationExpression;
import org.apache.olingo.client.core.edm.xml.v4.annotation.CastImpl;
import org.apache.olingo.commons.api.edm.geo.SRID;

public class CastDeserializer
extends AbstractEdmDeserializer<CastImpl> {
    protected CastImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        CastImpl cast = new CastImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Type".equals(jp.getCurrentName())) {
                    cast.setType(jp.nextTextValue());
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    cast.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                } else if ("MaxLength".equals(jp.getCurrentName())) {
                    String maxLenght = jp.nextTextValue();
                    cast.setMaxLength(Integer.valueOf(maxLenght.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.valueOf(maxLenght)));
                } else if ("Precision".equals(jp.getCurrentName())) {
                    cast.setPrecision(Integer.valueOf(jp.nextTextValue()));
                } else if ("Scale".equals(jp.getCurrentName())) {
                    String scale = jp.nextTextValue();
                    cast.setScale(Integer.valueOf(scale.equalsIgnoreCase("variable") ? 0 : Integer.valueOf(scale)));
                } else if ("SRID".equals(jp.getCurrentName())) {
                    String srid = jp.nextTextValue();
                    if (srid != null) {
                        cast.setSrid(SRID.valueOf((String)srid));
                    }
                } else {
                    cast.setValue((DynamicAnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class));
                }
            }
            jp.nextToken();
        }
        return cast;
    }
}

