/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import java.net.URI;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.IncludeAnnotationsImpl;
import org.apache.olingo.client.core.edm.xml.v4.IncludeImpl;
import org.apache.olingo.client.core.edm.xml.v4.ReferenceImpl;

public class ReferenceDeserializer
extends AbstractEdmDeserializer<ReferenceImpl> {
    protected ReferenceImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ReferenceImpl reference = new ReferenceImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Uri".equals(jp.getCurrentName())) {
                    reference.setUri(URI.create(jp.nextTextValue()));
                } else if ("Include".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    reference.getIncludes().add(jp.readValueAs(IncludeImpl.class));
                } else if ("IncludeAnnotations".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    reference.getIncludeAnnotations().add(jp.readValueAs(IncludeAnnotationsImpl.class));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    reference.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return reference;
    }
}

