/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.olingo.client.api.edm.xml.v4.annotation.AnnotationExpression;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.annotation.AbstractDynamicAnnotationExpression;

public class AnnotationDeserializer
extends AbstractEdmDeserializer<AnnotationImpl> {
    protected AnnotationImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        AnnotationImpl annotation = new AnnotationImpl();
        while (jp.getCurrentToken() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Term".equals(jp.getCurrentName())) {
                    annotation.setTerm(jp.nextTextValue());
                } else if ("Qualifier".equals(jp.getCurrentName())) {
                    annotation.setQualifier(jp.nextTextValue());
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    annotation.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                } else if (this.isAnnotationConstExprConstruct(jp)) {
                    annotation.setAnnotationExpression((AnnotationExpression)this.parseAnnotationConstExprConstruct(jp));
                } else {
                    annotation.setAnnotationExpression((AnnotationExpression)jp.readValueAs(AbstractDynamicAnnotationExpression.class));
                }
            }
            jp.nextToken();
        }
        return annotation;
    }
}

