/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml.v4;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.api.edm.xml.v4.ReturnType;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.v4.ActionImpl;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.ParameterImpl;

public class ActionDeserializer
extends AbstractEdmDeserializer<ActionImpl> {
    protected ActionImpl doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ActionImpl action = new ActionImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    action.setName(jp.nextTextValue());
                } else if ("IsBound".equals(jp.getCurrentName())) {
                    action.setBound(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("EntitySetPath".equals(jp.getCurrentName())) {
                    action.setEntitySetPath(jp.nextTextValue());
                } else if ("Parameter".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    action.getParameters().add(jp.readValueAs(ParameterImpl.class));
                } else if ("ReturnType".equals(jp.getCurrentName())) {
                    action.setReturnType((ReturnType)this.parseReturnType(jp, "Action"));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    action.getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return action;
    }
}

