/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.olingo.client.core.edm.xml.AbstractEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.AbstractEntitySet;
import org.apache.olingo.client.core.edm.xml.v3.EntitySetImpl;
import org.apache.olingo.client.core.edm.xml.v4.AnnotationImpl;
import org.apache.olingo.client.core.edm.xml.v4.NavigationPropertyBindingImpl;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;

public class EntitySetDeserializer
extends AbstractEdmDeserializer<AbstractEntitySet> {
    protected AbstractEntitySet doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        EntitySetImpl entitySet;
        Object object = entitySet = ODataServiceVersion.V30 == this.version ? new EntitySetImpl() : new org.apache.olingo.client.core.edm.xml.v4.EntitySetImpl();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.FIELD_NAME) {
                if ("Name".equals(jp.getCurrentName())) {
                    entitySet.setName(jp.nextTextValue());
                } else if ("EntityType".equals(jp.getCurrentName())) {
                    entitySet.setEntityType(jp.nextTextValue());
                } else if ("IncludeInServiceDocument".equals(jp.getCurrentName())) {
                    ((org.apache.olingo.client.core.edm.xml.v4.EntitySetImpl)entitySet).setIncludeInServiceDocument(BooleanUtils.toBoolean((String)jp.nextTextValue()));
                } else if ("NavigationPropertyBinding".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    ((org.apache.olingo.client.core.edm.xml.v4.EntitySetImpl)entitySet).getNavigationPropertyBindings().add(jp.readValueAs(NavigationPropertyBindingImpl.class));
                } else if ("Annotation".equals(jp.getCurrentName())) {
                    jp.nextToken();
                    ((org.apache.olingo.client.core.edm.xml.v4.EntitySetImpl)entitySet).getAnnotations().add(jp.readValueAs(AnnotationImpl.class));
                }
            }
            jp.nextToken();
        }
        return entitySet;
    }
}

