/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.edm.xml.ComplexType;
import org.apache.olingo.client.api.edm.xml.EntityContainer;
import org.apache.olingo.client.api.edm.xml.EntityType;
import org.apache.olingo.client.api.edm.xml.EnumType;
import org.apache.olingo.client.api.edm.xml.Schema;
import org.apache.olingo.client.api.edm.xml.v3.FunctionImport;
import org.apache.olingo.client.api.edm.xml.v4.Action;
import org.apache.olingo.client.api.edm.xml.v4.Annotation;
import org.apache.olingo.client.api.edm.xml.v4.Annotations;
import org.apache.olingo.client.api.edm.xml.v4.Function;
import org.apache.olingo.client.api.edm.xml.v4.Term;
import org.apache.olingo.client.api.edm.xml.v4.TypeDefinition;
import org.apache.olingo.client.core.edm.EdmActionImpl;
import org.apache.olingo.client.core.edm.EdmAnnotationImpl;
import org.apache.olingo.client.core.edm.EdmAnnotationsImpl;
import org.apache.olingo.client.core.edm.EdmComplexTypeImpl;
import org.apache.olingo.client.core.edm.EdmEntityContainerImpl;
import org.apache.olingo.client.core.edm.EdmEntityTypeImpl;
import org.apache.olingo.client.core.edm.EdmEnumTypeImpl;
import org.apache.olingo.client.core.edm.EdmFunctionImpl;
import org.apache.olingo.client.core.edm.EdmTermImpl;
import org.apache.olingo.client.core.edm.EdmTypeDefinitionImpl;
import org.apache.olingo.client.core.edm.v3.EdmActionProxy;
import org.apache.olingo.client.core.edm.v3.EdmFunctionProxy;
import org.apache.olingo.client.core.edm.v3.FunctionImportUtils;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.edm.AbstractEdmSchema;

public class EdmSchemaImpl
extends AbstractEdmSchema {
    private final ODataServiceVersion version;
    private final Edm edm;
    private final List<? extends Schema> xmlSchemas;
    private final Schema schema;
    private Map<FullQualifiedName, EdmEntityContainer> entityContainerByName;
    private List<EdmEntityContainer> entityContainers;

    public EdmSchemaImpl(ODataServiceVersion version, Edm edm, List<? extends Schema> xmlSchemas, Schema schema) {
        super(schema.getNamespace(), schema.getAlias());
        this.version = version;
        this.edm = edm;
        this.xmlSchemas = xmlSchemas;
        this.schema = schema;
    }

    public List<EdmEntityContainer> getEntityContainers() {
        if (this.entityContainers == null) {
            this.entityContainerByName = new HashMap();
            if (this.schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema) {
                this.entityContainers = super.getEntityContainers();
                if (this.getEntityContainer() != null) {
                    this.entityContainerByName.put(this.getEntityContainer().getFullQualifiedName(), this.getEntityContainer());
                }
            } else {
                this.entityContainers = new ArrayList(this.schema.getEntityContainers().size());
                for (EntityContainer entityContainer : this.schema.getEntityContainers()) {
                    EdmEntityContainer edmContainer = this.createEntityContainer(entityContainer.getName());
                    if (edmContainer == null) continue;
                    this.entityContainers.add(edmContainer);
                    this.entityContainerByName.put(edmContainer.getFullQualifiedName(), edmContainer);
                }
            }
        }
        return this.entityContainers;
    }

    public EdmEntityContainer getEntityContainer(FullQualifiedName name) {
        this.getEntityContainers();
        return (EdmEntityContainer)this.entityContainerByName.get(name);
    }

    private EdmEntityContainer createEntityContainer(String name) {
        EntityContainer defaultContainer = this.schema.getEntityContainer(name);
        if (defaultContainer != null) {
            FullQualifiedName entityContainerName = new FullQualifiedName(this.schema.getNamespace(), defaultContainer.getName());
            return new EdmEntityContainerImpl(this.edm, entityContainerName, defaultContainer, this.xmlSchemas);
        }
        return null;
    }

    protected EdmEntityContainer createEntityContainer() {
        EntityContainer defaultContainer = this.schema.getDefaultEntityContainer();
        if (defaultContainer != null) {
            return this.createEntityContainer(defaultContainer.getName());
        }
        return null;
    }

    protected List<EdmTypeDefinition> createTypeDefinitions() {
        List providerTypeDefinitions;
        ArrayList<EdmTypeDefinition> typeDefinitions = new ArrayList<EdmTypeDefinition>();
        if (this.schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema && (providerTypeDefinitions = ((org.apache.olingo.client.api.edm.xml.v4.Schema)this.schema).getTypeDefinitions()) != null) {
            for (TypeDefinition def : providerTypeDefinitions) {
                typeDefinitions.add((EdmTypeDefinition)new EdmTypeDefinitionImpl(this.version, this.edm, new FullQualifiedName(this.namespace, def.getName()), def));
            }
        }
        return typeDefinitions;
    }

    protected List<EdmEnumType> createEnumTypes() {
        ArrayList<EdmEnumType> enumTypes = new ArrayList<EdmEnumType>();
        List providerEnumTypes = this.schema.getEnumTypes();
        if (providerEnumTypes != null) {
            for (EnumType enumType : providerEnumTypes) {
                enumTypes.add((EdmEnumType)new EdmEnumTypeImpl(this.version, this.edm, new FullQualifiedName(this.namespace, enumType.getName()), enumType));
            }
        }
        return enumTypes;
    }

    protected List<EdmEntityType> createEntityTypes() {
        ArrayList<EdmEntityType> entityTypes = new ArrayList<EdmEntityType>();
        List providerEntityTypes = this.schema.getEntityTypes();
        if (providerEntityTypes != null) {
            for (EntityType entityType : providerEntityTypes) {
                entityTypes.add((EdmEntityType)EdmEntityTypeImpl.getInstance((Edm)this.edm, (FullQualifiedName)new FullQualifiedName(this.namespace, entityType.getName()), (List)this.xmlSchemas, (EntityType)entityType));
            }
        }
        return entityTypes;
    }

    protected List<EdmComplexType> createComplexTypes() {
        ArrayList<EdmComplexType> complexTypes = new ArrayList<EdmComplexType>();
        List providerComplexTypes = this.schema.getComplexTypes();
        if (providerComplexTypes != null) {
            for (ComplexType complexType : providerComplexTypes) {
                complexTypes.add((EdmComplexType)EdmComplexTypeImpl.getInstance((Edm)this.edm, (FullQualifiedName)new FullQualifiedName(this.namespace, complexType.getName()), (List)this.xmlSchemas, (ComplexType)complexType));
            }
        }
        return complexTypes;
    }

    protected List<EdmAction> createActions() {
        ArrayList<EdmAction> actions;
        block4: {
            block3: {
                actions = new ArrayList<EdmAction>();
                if (!(this.schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema)) break block3;
                List providerActions = ((org.apache.olingo.client.api.edm.xml.v4.Schema)this.schema).getActions();
                if (providerActions == null) break block4;
                for (Action action : providerActions) {
                    actions.add((EdmAction)EdmActionImpl.getInstance((Edm)this.edm, (FullQualifiedName)new FullQualifiedName(this.namespace, action.getName()), (Action)action));
                }
                break block4;
            }
            for (EntityContainer providerContainer : this.schema.getEntityContainers()) {
                List providerFunctions = providerContainer.getFunctionImports();
                if (providerFunctions == null) continue;
                for (FunctionImport functionImport : providerFunctions) {
                    if (FunctionImportUtils.canProxyFunction((FunctionImport)functionImport)) continue;
                    actions.add((EdmAction)EdmActionProxy.getInstance((Edm)this.edm, (FullQualifiedName)new FullQualifiedName(this.namespace, functionImport.getName()), (FunctionImport)functionImport));
                }
            }
        }
        return actions;
    }

    protected List<EdmFunction> createFunctions() {
        ArrayList<EdmFunction> functions = new ArrayList<EdmFunction>();
        if (this.schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema) {
            List providerFunctions = ((org.apache.olingo.client.api.edm.xml.v4.Schema)this.schema).getFunctions();
            if (providerFunctions != null) {
                for (Function function : providerFunctions) {
                    functions.add((EdmFunction)EdmFunctionImpl.getInstance((Edm)this.edm, (FullQualifiedName)new FullQualifiedName(this.namespace, function.getName()), (Function)function));
                }
                return functions;
            }
        } else {
            for (EntityContainer providerContainer : this.schema.getEntityContainers()) {
                List providerFunctions = providerContainer.getFunctionImports();
                if (providerFunctions == null) continue;
                for (FunctionImport functionImport : providerFunctions) {
                    if (!FunctionImportUtils.canProxyFunction((FunctionImport)functionImport)) continue;
                    functions.add((EdmFunction)EdmFunctionProxy.getInstance((Edm)this.edm, (FullQualifiedName)new FullQualifiedName(this.namespace, functionImport.getName()), (FunctionImport)functionImport));
                }
            }
        }
        return functions;
    }

    protected List<EdmTerm> createTerms() {
        List providerTerms;
        ArrayList<EdmTerm> terms = new ArrayList<EdmTerm>();
        if (this.schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema && (providerTerms = ((org.apache.olingo.client.api.edm.xml.v4.Schema)this.schema).getTerms()) != null) {
            for (Term term : providerTerms) {
                terms.add((EdmTerm)new EdmTermImpl(this.edm, this.getNamespace(), term));
            }
        }
        return terms;
    }

    protected List<EdmAnnotations> createAnnotationGroups() {
        List providerAnnotations;
        ArrayList<EdmAnnotations> annotationGroups = new ArrayList<EdmAnnotations>();
        if (this.schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema && (providerAnnotations = ((org.apache.olingo.client.api.edm.xml.v4.Schema)this.schema).getAnnotationGroups()) != null) {
            for (Annotations annotationGroup : providerAnnotations) {
                annotationGroups.add((EdmAnnotations)new EdmAnnotationsImpl(this.edm, (EdmSchema)this, annotationGroup));
            }
        }
        return annotationGroups;
    }

    protected List<EdmAnnotation> createAnnotations() {
        List providerAnnotations;
        ArrayList<EdmAnnotation> annotations = new ArrayList<EdmAnnotation>();
        if (this.schema instanceof org.apache.olingo.client.api.edm.xml.v4.Schema && (providerAnnotations = ((org.apache.olingo.client.api.edm.xml.v4.Schema)this.schema).getAnnotations()) != null) {
            for (Annotation annotation : providerAnnotations) {
                annotations.add((EdmAnnotation)new EdmAnnotationImpl(this.edm, annotation));
            }
        }
        return annotations;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        EdmAnnotation result = null;
        for (EdmAnnotation annotation : this.getAnnotations()) {
            if (!term.getFullQualifiedName().equals((Object)annotation.getTerm().getFullQualifiedName())) continue;
            result = annotation;
        }
        return result;
    }
}

