/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.edm.xml.CommonParameter;
import org.apache.olingo.client.api.edm.xml.v4.Action;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.Parameter;
import org.apache.olingo.client.api.edm.xml.v4.ReturnType;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.client.core.edm.EdmParameterImpl;
import org.apache.olingo.client.core.edm.EdmReturnTypeImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.core.edm.AbstractEdmOperation;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;

public abstract class EdmOperationImpl
extends AbstractEdmOperation {
    protected final Action operation;
    protected final EdmAnnotationHelper helper;

    protected static <T extends EdmOperationImpl> T getInstance(T instance) {
        List parameters = instance.operation.getParameters();
        ArrayList<EdmParameterImpl> _parameters = new ArrayList<EdmParameterImpl>(parameters.size());
        for (CommonParameter parameter : parameters) {
            _parameters.add(new EdmParameterImpl(instance.edm, parameter));
        }
        instance.setParameters(_parameters);
        String entitySetPath = instance.operation.getEntitySetPath();
        if (StringUtils.isNotBlank((CharSequence)entitySetPath)) {
            int firstSlashIndex = entitySetPath.indexOf("/");
            instance.setEntitySetPath(entitySetPath.substring(firstSlashIndex + 1));
        }
        instance.setIsBound(instance.operation.isBound());
        if (instance.operation.getReturnType() != null) {
            instance.setReturnType((EdmReturnType)EdmReturnTypeImpl.getInstance((Edm)instance.edm, (ReturnType)instance.operation.getReturnType()));
        }
        return instance;
    }

    protected EdmOperationImpl(Edm edm, FullQualifiedName name, Action operation, EdmTypeKind kind) {
        super(edm, name, kind);
        this.operation = operation;
        this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)operation);
    }

    private EdmParameter getBindingParameter() {
        EdmParameter bindingParam = null;
        if (this.isBound()) {
            String bindingParamName = ((Parameter)this.operation.getParameters().get(0)).getName();
            bindingParam = this.getParameter(bindingParamName);
        }
        return bindingParam;
    }

    public FullQualifiedName getBindingParameterTypeFqn() {
        FullQualifiedName bpfqn = null;
        EdmParameter bindingParam = this.getBindingParameter();
        if (bindingParam != null) {
            bpfqn = new FullQualifiedName(bindingParam.getType().getNamespace(), bindingParam.getType().getName());
        }
        return bpfqn;
    }

    public Boolean isBindingParameterTypeCollection() {
        Boolean result = null;
        EdmParameter bindingParam = this.getBindingParameter();
        if (bindingParam != null) {
            result = bindingParam.isCollection();
        }
        return result;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper.getAnnotations();
    }
}

