/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.api.edm.xml.v4.Annotatable;
import org.apache.olingo.client.api.edm.xml.v4.BindingTarget;
import org.apache.olingo.client.api.edm.xml.v4.NavigationPropertyBinding;
import org.apache.olingo.client.core.edm.EdmAnnotationHelperImpl;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmBindingTarget;
import org.apache.olingo.commons.core.edm.EdmAnnotationHelper;
import org.apache.olingo.commons.core.edm.EdmNavigationPropertyBindingImpl;

public abstract class EdmBindingTargetImpl
extends AbstractEdmBindingTarget {
    private final BindingTarget target;
    private final EdmAnnotationHelper helper;
    private List<EdmNavigationPropertyBinding> navigationPropertyBindings;

    public EdmBindingTargetImpl(Edm edm, EdmEntityContainer container, String name, FullQualifiedName type, BindingTarget target) {
        super(edm, container, name, type);
        this.target = target;
        this.helper = new EdmAnnotationHelperImpl(edm, (Annotatable)target);
    }

    public List<EdmNavigationPropertyBinding> getNavigationPropertyBindings() {
        if (this.navigationPropertyBindings == null) {
            List providerBindings = this.target.getNavigationPropertyBindings();
            this.navigationPropertyBindings = new ArrayList();
            if (providerBindings != null) {
                for (NavigationPropertyBinding binding : providerBindings) {
                    this.navigationPropertyBindings.add(new EdmNavigationPropertyBindingImpl(binding.getPath(), binding.getTarget()));
                }
            }
        }
        return this.navigationPropertyBindings;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        return this.helper.getAnnotation(term);
    }

    public List<EdmAnnotation> getAnnotations() {
        return this.helper.getAnnotations();
    }
}

