/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.invoke;

import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.invoke.ODataInvokeRequest;
import org.apache.olingo.client.api.communication.response.ODataInvokeResponse;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.api.v4.ODataClient;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.request.invoke.AbstractODataInvokeRequest;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.domain.CommonODataProperty;
import org.apache.olingo.commons.api.domain.ODataInvokeResult;
import org.apache.olingo.commons.api.domain.v4.ODataValue;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public abstract class AbstractODataInvokeRequest<T extends ODataInvokeResult>
extends AbstractODataBasicRequest<ODataInvokeResponse<T>>
implements ODataInvokeRequest<T>,
ODataBatchableRequest {
    private final Class<T> reference;
    protected Map<String, org.apache.olingo.commons.api.domain.ODataValue> parameters;

    public AbstractODataInvokeRequest(CommonODataClient<?> odataClient, Class<T> reference, HttpMethod method, URI uri) {
        super(odataClient, method, uri);
        this.reference = reference;
        this.parameters = new LinkedHashMap();
    }

    public void setParameters(Map<String, org.apache.olingo.commons.api.domain.ODataValue> parameters) {
        this.parameters.clear();
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters.putAll(parameters);
        }
    }

    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    private String getActualFormat(ODataFormat format) {
        return (CommonODataProperty.class.isAssignableFrom(this.reference) && format == ODataFormat.ATOM ? ODataFormat.XML : format).getContentType(this.odataClient.getServiceVersion()).toContentTypeString();
    }

    public void setFormat(ODataFormat format) {
        String _format = this.getActualFormat(format);
        this.setAccept(_format);
        this.setContentType(_format);
    }

    protected abstract ODataFormat getPOSTParameterFormat();

    protected InputStream getPayload() {
        if (!this.parameters.isEmpty() && this.method == HttpMethod.POST) {
            CommonODataEntity tmp = this.odataClient.getObjectFactory().newEntity(null);
            for (Map.Entry param : this.parameters.entrySet()) {
                CommonODataProperty property = null;
                if (((org.apache.olingo.commons.api.domain.ODataValue)param.getValue()).isPrimitive()) {
                    property = this.odataClient.getObjectFactory().newPrimitiveProperty((String)param.getKey(), ((org.apache.olingo.commons.api.domain.ODataValue)param.getValue()).asPrimitive());
                } else if (((org.apache.olingo.commons.api.domain.ODataValue)param.getValue()).isComplex()) {
                    property = this.odataClient.getObjectFactory().newComplexProperty((String)param.getKey(), ((org.apache.olingo.commons.api.domain.ODataValue)param.getValue()).asComplex());
                } else if (((org.apache.olingo.commons.api.domain.ODataValue)param.getValue()).isCollection()) {
                    property = this.odataClient.getObjectFactory().newCollectionProperty((String)param.getKey(), ((org.apache.olingo.commons.api.domain.ODataValue)param.getValue()).asCollection());
                } else if (param.getValue() instanceof ODataValue && ((ODataValue)param.getValue()).isEnum()) {
                    property = ((ODataClient)this.odataClient).getObjectFactory().newEnumProperty((String)param.getKey(), ((ODataValue)param.getValue()).asEnum());
                }
                if (property == null) continue;
                this.odataClient.getBinder().add(tmp, property);
            }
            try {
                return this.odataClient.getWriter().writeEntity(tmp, this.getPOSTParameterFormat());
            }
            catch (ODataSerializerException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataInvokeResponse<T> execute() {
        InputStream input = this.getPayload();
        if (!this.parameters.isEmpty()) {
            if (this.method == HttpMethod.GET) {
                ((HttpRequestBase)this.request).setURI(URIUtils.buildFunctionInvokeURI((URI)this.uri, (Map)this.parameters, (ODataServiceVersion)this.odataClient.getServiceVersion()));
            } else if (this.method == HttpMethod.POST) {
                ((HttpPost)this.request).setEntity(URIUtils.buildInputStreamEntity((CommonODataClient)this.odataClient, (InputStream)input));
                this.setContentType(this.getActualFormat(this.getPOSTParameterFormat()));
            }
        }
        try {
            ODataInvokeResponseImpl oDataInvokeResponseImpl = new ODataInvokeResponseImpl(this, this.odataClient, this.httpClient, this.doExecute(), null);
            return oDataInvokeResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    static /* synthetic */ Class access$100(AbstractODataInvokeRequest x0) {
        return x0.reference;
    }
}

