/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityUpdateRequest;
import org.apache.olingo.client.api.communication.response.ODataEntityUpdateResponse;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.request.cud.ODataEntityUpdateRequestImpl;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.domain.CommonODataEntity;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;

public class ODataEntityUpdateRequestImpl<E extends CommonODataEntity>
extends AbstractODataBasicRequest<ODataEntityUpdateResponse<E>>
implements ODataEntityUpdateRequest<E> {
    private final E changes;

    public ODataEntityUpdateRequestImpl(CommonODataClient<?> odataClient, HttpMethod method, URI uri, E changes) {
        super(odataClient, method, uri);
        this.changes = changes;
    }

    public ODataFormat getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    protected InputStream getPayload() {
        try {
            return this.odataClient.getWriter().writeEntity(this.changes, ODataFormat.fromString((String)this.getContentType()));
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataEntityUpdateResponse<E> execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity((CommonODataClient)this.odataClient, (InputStream)input));
        try {
            HttpResponse httpResponse = this.doExecute();
            ODataEntityUpdateResponseImpl response = new ODataEntityUpdateResponseImpl(this, this.odataClient, this.httpClient, httpResponse, null);
            if (httpResponse.getStatusLine().getStatusCode() == 204) {
                response.close();
            }
            ODataEntityUpdateResponseImpl oDataEntityUpdateResponseImpl = response;
            return oDataEntityUpdateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }
}

