/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.util.UUID;
import org.apache.olingo.client.api.communication.header.HeaderName;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.request.batch.CommonODataBatchRequest;
import org.apache.olingo.client.api.communication.request.batch.ODataChangeset;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.request.batch.AbstractODataBatchRequestItem;
import org.apache.olingo.client.core.communication.request.batch.ODataChangesetResponseItem;
import org.apache.olingo.commons.api.format.ContentType;

public class ODataChangesetImpl
extends AbstractODataBatchRequestItem
implements ODataChangeset {
    private int contentId = 0;
    private final String boundary;
    private final ODataChangesetResponseItem expectedResItem;

    ODataChangesetImpl(CommonODataBatchRequest req, ODataChangesetResponseItem expectedResItem) {
        super(req);
        this.expectedResItem = expectedResItem;
        this.boundary = "changeset_" + UUID.randomUUID().toString();
    }

    public int getLastContentId() {
        return this.contentId;
    }

    protected void closeItem() {
        if (this.hasStreamedSomething) {
            this.newLine();
            this.stream(("--" + this.boundary + "--").getBytes());
            this.newLine();
            this.newLine();
        }
    }

    public ODataChangeset addRequest(ODataBatchableRequest request) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Current batch item is closed");
        }
        if (request.getMethod() == HttpMethod.GET) {
            throw new IllegalArgumentException("Invalid request. GET method not allowed in changeset");
        }
        if (!this.hasStreamedSomething) {
            this.stream((HeaderName.contentType.toString() + ": " + ContentType.MULTIPART_MIXED + ";boundary=" + this.boundary).getBytes());
            this.newLine();
            this.newLine();
            this.hasStreamedSomething = true;
        }
        ++this.contentId;
        this.newLine();
        this.stream(("--" + this.boundary).getBytes());
        this.newLine();
        this.streamRequestHeader(String.valueOf(this.contentId));
        request.batch(this.req, String.valueOf(this.contentId));
        this.expectedResItem.addResponse(String.valueOf(this.contentId), ((AbstractODataRequest)request).getResponseTemplate());
        return this;
    }
}

