/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchLineIterator;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchResponseItem;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractODataBatchResponseItem
implements ODataBatchResponseItem {
    protected static final Logger LOG = LoggerFactory.getLogger(ODataBatchResponseItem.class);
    protected final Map<String, ODataResponse> responses = new HashMap();
    protected Iterator<ODataResponse> expectedItemsIterator;
    private final boolean changeset;
    protected ODataBatchLineIterator batchLineIterator;
    protected String boundary;
    protected boolean closed = false;
    protected ODataResponse current;
    protected boolean breaking = false;

    public AbstractODataBatchResponseItem(boolean isChangeset) {
        this.changeset = isChangeset;
        this.current = null;
    }

    public void addResponse(String contentId, ODataResponse res) {
        if (this.closed) {
            throw new IllegalStateException("Invalid batch item because explicitely closed");
        }
        this.responses.put(contentId, res);
    }

    public void initFromBatch(ODataBatchLineIterator batchLineIterator, String boundary) {
        if (this.closed) {
            throw new IllegalStateException("Invalid batch item because explicitely closed");
        }
        LOG.debug("Init from batch - boundary '{}'", (Object)boundary);
        this.batchLineIterator = batchLineIterator;
        this.boundary = boundary;
    }

    protected ODataResponse getResponse(String contentId) {
        if (this.closed) {
            throw new IllegalStateException("Invalid batch item because explicitely closed");
        }
        return (ODataResponse)this.responses.get(contentId);
    }

    protected Iterator<ODataResponse> getResponseIterator() {
        if (this.closed) {
            throw new IllegalStateException("Invalid batch item because explicitely closed");
        }
        return this.responses.values().iterator();
    }

    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Invalid request - the item has been closed");
        }
        if (this.expectedItemsIterator == null) {
            this.expectedItemsIterator = this.responses.values().iterator();
        }
        return !this.breaking && this.expectedItemsIterator.hasNext();
    }

    public boolean isBreaking() {
        return this.breaking;
    }

    public final boolean isChangeset() {
        return this.changeset;
    }

    public void close() {
        for (ODataResponse response : this.responses.values()) {
            response.close();
        }
        this.closed = true;
    }
}

