/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.CommonODataClient;
import org.apache.olingo.client.api.ODataBatchConstants;
import org.apache.olingo.client.api.communication.request.ODataBasicRequest;
import org.apache.olingo.client.api.communication.request.ODataStreamer;
import org.apache.olingo.client.api.communication.request.batch.CommonODataBatchRequest;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.http.HttpMethod;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.commons.api.format.ODataFormat;

public abstract class AbstractODataBasicRequest<T extends ODataResponse>
extends AbstractODataRequest
implements ODataBasicRequest<T> {
    public AbstractODataBasicRequest(CommonODataClient<?> odataClient, HttpMethod method, URI uri) {
        super(odataClient, method, uri);
    }

    public void setFormat(ODataFormat format) {
        if (format != null) {
            String formatString = format.getContentType(this.odataClient.getServiceVersion()).toContentTypeString();
            this.setAccept(formatString);
            this.setContentType(formatString);
        }
    }

    public final Future<T> asyncExecute() {
        return this.odataClient.getConfiguration().getExecutor().submit(new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract InputStream getPayload();

    public void batch(CommonODataBatchRequest req) {
        this.batch(req, null);
    }

    public void batch(CommonODataBatchRequest req, String contentId) {
        try {
            req.rawAppend(this.toByteArray());
            if (StringUtils.isNotBlank((CharSequence)contentId)) {
                req.rawAppend((ODataBatchConstants.CHANGESET_CONTENT_ID_NAME + ": " + contentId).getBytes());
                req.rawAppend(ODataStreamer.CRLF);
            }
            req.rawAppend(ODataStreamer.CRLF);
            InputStream payload = this.getPayload();
            if (payload != null) {
                req.rawAppend(IOUtils.toByteArray((InputStream)this.getPayload()));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

