/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.CorrelationSetDaoImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.PartnerLinkDAOImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.XmlDataDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HPartnerLink;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.SerializableUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;
import org.apache.ode.utils.stl.UnaryFunctionEx;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeDaoImpl
extends HibernateDao
implements ScopeDAO {
    private static final String QRY_VARIABLE = "from " + HXmlData.class.getName() + " as x where x.name = ? and x.scope.id = ?";
    private static final String QRY_CSET = "from " + HCorrelationSet.class.getName() + " as c where c.name = ? and c.scope.id = ?";
    private static final String QRY_SCOPE_EPR = "from " + HPartnerLink.class.getName() + " as e where e.modelId = ? and e.scope = ?";
    private HScope _scope;
    private HashMap<String, XmlDataDAO> _variables = new HashMap();

    public ScopeDaoImpl(SessionManager sessionManager, HScope hScope) {
        super(sessionManager, hScope);
        this.entering("ScopeDaoImpl.ScopeDaoImpl");
        this._scope = hScope;
    }

    public CorrelationSetDAO getCorrelationSet(String string) {
        HCorrelationSet hCorrelationSet;
        this.entering("ScopeDaoImpl.getCorrelationSet");
        Query query = this.getSession().createQuery(QRY_CSET);
        query.setString(0, string);
        query.setLong(1, this._scope.getId().longValue());
        List list = query.list();
        if (list.size() == 0) {
            hCorrelationSet = new HCorrelationSet(this._scope, string);
            this.getSession().save((Object)hCorrelationSet);
        } else {
            hCorrelationSet = (HCorrelationSet)list.get(0);
        }
        return new CorrelationSetDaoImpl(this._sm, hCorrelationSet);
    }

    public ScopeDAO getParentScope() {
        this.entering("ScopeDaoImpl.getParentScope");
        return this._scope.getParentScope() != null ? new ScopeDaoImpl(this._sm, this._scope.getParentScope()) : null;
    }

    public ProcessInstanceDAO getProcessInstance() {
        this.entering("ScopeDaoImpl.getProcessInstance");
        return new ProcessInstanceDaoImpl(this._sm, this._scope.getInstance());
    }

    public void setState(ScopeStateEnum scopeStateEnum) {
        this.entering("ScopeDaoImpl.setState");
        this._scope.setState(scopeStateEnum.toString());
        this.getSession().update((Object)this._scope);
    }

    public ScopeStateEnum getState() {
        return ScopeStateEnum.valueOf((String)this._scope.getState());
    }

    public String getName() {
        return this._scope.getName();
    }

    public XmlDataDAO getVariable(String string) {
        this.entering("ScopeDaoImpl.getVariable");
        XmlDataDAO xmlDataDAO = this._variables.get(string);
        if (xmlDataDAO != null) {
            return this._variables.get(string);
        }
        HXmlData hXmlData = null;
        for (HXmlData hXmlData2 : this._scope.getVariables()) {
            if (!hXmlData2.getName().equals(string) || !hXmlData2.getScope().getId().equals(this._scope.getId())) continue;
            hXmlData = hXmlData2;
        }
        if (hXmlData == null) {
            hXmlData = new HXmlData();
            hXmlData.setName(string);
            hXmlData.setScope(this._scope);
            this._scope.getVariables().add(hXmlData);
        }
        XmlDataDaoImpl xmlDataDaoImpl = new XmlDataDaoImpl(this._sm, hXmlData);
        this._variables.put(string, xmlDataDaoImpl);
        return xmlDataDaoImpl;
    }

    public PartnerLinkDAO createPartnerLink(int n, String string, String string2, String string3) {
        this.entering("ScopeDaoImpl.createPartnerLink");
        HPartnerLink hPartnerLink = new HPartnerLink();
        hPartnerLink.setModelId(n);
        hPartnerLink.setLinkName(string);
        hPartnerLink.setMyRole(string2);
        hPartnerLink.setPartnerRole(string3);
        hPartnerLink.setScope(this._scope);
        this.getSession().save((Object)hPartnerLink);
        PartnerLinkDAOImpl partnerLinkDAOImpl = new PartnerLinkDAOImpl(this._sm, hPartnerLink);
        return partnerLinkDAOImpl;
    }

    public PartnerLinkDAO getPartnerLink(int n) {
        this.entering("ScopeDaoImpl.getPartnerLink");
        Query query = this.getSession().createQuery(QRY_SCOPE_EPR);
        query.setInteger(0, n);
        query.setEntity(1, (Object)this._scope);
        HPartnerLink hPartnerLink = (HPartnerLink)query.uniqueResult();
        if (hPartnerLink == null) {
            return null;
        }
        return new PartnerLinkDAOImpl(this._sm, hPartnerLink);
    }

    public Collection<PartnerLinkDAO> getPartnerLinks() {
        this.entering("ScopeDaoImpl.getPartnerLinks");
        ArrayList<PartnerLinkDAO> arrayList = new ArrayList<PartnerLinkDAO>();
        for (HPartnerLink hPartnerLink : this._scope.getPartnerLinks()) {
            arrayList.add(new PartnerLinkDAOImpl(this._sm, hPartnerLink));
        }
        return arrayList;
    }

    public Long getScopeInstanceId() {
        return this._scope.getId();
    }

    public int getModelId() {
        return this._scope.getScopeModelId();
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        this.entering("ScopeDaoImpl.getCorrelationSets");
        HashSet<CorrelationSetDAO> hashSet = new HashSet<CorrelationSetDAO>();
        for (HCorrelationSet hCorrelationSet : this._scope.getCorrelationSets()) {
            hashSet.add(new CorrelationSetDaoImpl(this._sm, hCorrelationSet));
        }
        return hashSet;
    }

    public Collection<ScopeDAO> getChildScopes() {
        this.entering("ScopeDaoImpl.getChildScopes");
        Query query = this.getSession().createQuery("from " + HScope.class.getName() + " as x where x.parentScope=?");
        query.setEntity(0, (Object)this._scope);
        List list = query.list();
        return CollectionsX.transform(new LinkedList(), (Collection)list, (UnaryFunction)new UnaryFunction<HScope, ScopeDAO>(){

            public ScopeDAO apply(HScope hScope) {
                return new ScopeDaoImpl(ScopeDaoImpl.this._sm, hScope);
            }
        });
    }

    public Collection<XmlDataDAO> getVariables() {
        this.entering("ScopeDaoImpl.getVariables");
        Query query = this.getSession().createFilter(this._scope.getVariables(), "where this.scope=?");
        query.setEntity(0, (Object)this._scope);
        return CollectionsX.transform(new LinkedList(), (Collection)query.list(), (UnaryFunction)new UnaryFunction<HXmlData, XmlDataDAO>(){

            public XmlDataDAO apply(HXmlData hXmlData) {
                return new XmlDataDaoImpl(ScopeDaoImpl.this._sm, hXmlData);
            }
        });
    }

    public List<BpelEvent> listEvents() {
        this.entering("ScopeDaoImpl.listEvents");
        Criteria criteria = this._sm.getSession().createCriteria(HBpelEvent.class);
        criteria.add((Criterion)Restrictions.eq((String)"scopeId", (Object)this._scope.getId()));
        List list = criteria.list();
        ArrayList<BpelEvent> arrayList = new ArrayList<BpelEvent>(list.size());
        try {
            CollectionsX.transformEx(arrayList, (Collection)list, (UnaryFunctionEx)new UnaryFunctionEx<HBpelEvent, BpelEvent>(){

                public BpelEvent apply(HBpelEvent hBpelEvent) throws Exception {
                    return (BpelEvent)SerializableUtils.toObject((byte[])hBpelEvent.getData(), (ClassLoader)BpelEvent.class.getClassLoader());
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return arrayList;
    }
}

