/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.RelativeDateParser;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

class CriteriaBuilder {
    static final Log __log = LogFactory.getLog(CriteriaBuilder.class);

    CriteriaBuilder() {
    }

    Query buildHQLQuery(Session session, InstanceFilter instanceFilter) {
        Query query;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select pi from HProcessInstance as pi left join fetch pi.fault ");
        if (instanceFilter != null) {
            String string;
            String string2;
            int n;
            Object object3;
            Object object2;
            query = new ArrayList();
            if (instanceFilter.getIidFilter() != null) {
                object2 = new StringBuffer();
                object3 = instanceFilter.getIidFilter();
                for (n = 0; n < object3.size(); ++n) {
                    ((StringBuffer)object2).append(" pi.id = :iid").append(n);
                    hashMap.put("iid" + n, Long.parseLong((String)object3.get(n)));
                    if (n >= object3.size() - 1) continue;
                    ((StringBuffer)object2).append(" or");
                }
                query.add(" (" + object2 + ")");
            }
            if (instanceFilter.getPidFilter() != null) {
                object2 = new StringBuffer();
                object3 = instanceFilter.getPidFilter();
                String string3 = instanceFilter.arePidsNegative() ? " != " : " = ";
                for (int i = 0; i < object3.size(); ++i) {
                    ((StringBuffer)object2).append(" pi.process.processId ").append(string3).append(" :pid").append(i);
                    hashMap.put("pid" + i, object3.get(i));
                    if (i >= object3.size() - 1) continue;
                    ((StringBuffer)object2).append(" or");
                }
                query.add(" (" + object2 + ")");
            }
            if (instanceFilter.getNameFilter() != null) {
                query.add(" pi.process.typeName like :pname");
                hashMap.put("pname", instanceFilter.getNameFilter().replaceAll("\\*", "%"));
            }
            if (instanceFilter.getNamespaceFilter() != null) {
                query.add(" pi.process.typeNamespace like :pnamespace");
                hashMap.put("pnamespace", instanceFilter.getNamespaceFilter().replaceAll("\\*", "%"));
            }
            if (instanceFilter.getStartedDateFilter() != null) {
                for (Object object3 : instanceFilter.getStartedDateFilter()) {
                    query.add(" pi.created " + CriteriaBuilder.dateFilter((String)object3));
                }
            }
            if (instanceFilter.getLastActiveDateFilter() != null) {
                for (Object object3 : instanceFilter.getLastActiveDateFilter()) {
                    query.add(" pi.lastActiveTime " + CriteriaBuilder.dateFilter((String)object3));
                }
            }
            if (instanceFilter.getStatusFilter() != null) {
                object2 = new StringBuffer();
                object3 = instanceFilter.convertFilterState();
                for (n = 0; n < object3.size(); ++n) {
                    ((StringBuffer)object2).append(" pi.state = :pstate").append(n);
                    hashMap.put("pstate" + n, object3.get(n));
                    if (n >= object3.size() - 1) continue;
                    ((StringBuffer)object2).append(" or");
                }
                query.add(" (" + ((StringBuffer)object2).toString() + ")");
            }
            if (instanceFilter.getPropertyValuesFilter() != null) {
                object2 = instanceFilter.getPropertyValuesFilter();
                stringBuffer.append(" inner join pi.correlationSets as cs");
                int n2 = 0;
                for (String string4 : object2.keySet()) {
                    stringBuffer.append(" inner join cs.properties as csp" + ++n2);
                    string2 = ((String)object2.get(string4)).replaceAll("&#32;", " ");
                    if (string4.startsWith("{")) {
                        string = string4.substring(1, string4.lastIndexOf("}"));
                        query.add(" csp" + n2 + ".name = :cspname" + n2 + " and csp" + n2 + ".namespace = :cspnamespace" + n2 + " and csp" + n2 + ".value = :cspvalue" + n2);
                        hashMap.put("cspname" + n2, string4.substring(string4.lastIndexOf("}") + 1, string4.length()));
                        hashMap.put("cspnamespace" + n2, string);
                        hashMap.put("cspvalue" + n2, string2);
                        continue;
                    }
                    query.add(" csp" + n2 + ".name = :cspname" + n2 + " and csp" + n2 + ".value = :cspvalue" + n2);
                    hashMap.put("cspname" + n2, string4);
                    hashMap.put("cspvalue" + n2, string2);
                }
            }
            object2 = new StringBuffer("");
            if (instanceFilter.getOrders() != null) {
                ((StringBuffer)object2).append(" order by");
                List list = instanceFilter.getOrders();
                for (int i = 0; i < list.size(); ++i) {
                    String string5 = (String)list.get(i);
                    string2 = " asc";
                    if (string5.startsWith("-")) {
                        string2 = " desc";
                    }
                    string = " pi.id";
                    if (string5.endsWith("name")) {
                        string = " pi.process.typeName";
                    }
                    if (string5.endsWith("namespace")) {
                        string = " pi.process.typeNamespace";
                    }
                    if (string5.endsWith("version")) {
                        string = " pi.process.version";
                    }
                    if (string5.endsWith("status")) {
                        string = " pi.state";
                    }
                    if (string5.endsWith("started")) {
                        string = " pi.created";
                    }
                    if (string5.endsWith("last-active")) {
                        string = " pi.lastActiveTime";
                    }
                    ((StringBuffer)object2).append(string + string2);
                    if (i >= list.size() - 1) continue;
                    ((StringBuffer)object2).append(", ");
                }
            }
            if (query.size() > 0) {
                stringBuffer.append(" where");
                for (int i = 0; i < query.size(); ++i) {
                    stringBuffer.append((String)query.get(i));
                    if (i >= query.size() - 1) continue;
                    stringBuffer.append(" and");
                }
            }
            stringBuffer.append((StringBuffer)object2);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)stringBuffer.toString());
        }
        query = session.createQuery(stringBuffer.toString());
        for (String string : hashMap.keySet()) {
            query.setParameter(string, hashMap.get(string));
        }
        if (instanceFilter.getLimit() != 0) {
            query.setMaxResults(instanceFilter.getLimit());
        }
        return query;
    }

    private static String dateFilter(String string) {
        String string2 = Filter.getDateWithoutOp((String)string);
        String string3 = string.substring(0, string.indexOf(string2));
        Date date = null;
        try {
            date = ISO8601DateParser.parse((String)string2);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        Timestamp timestamp = new Timestamp(date.getTime());
        return string3 + " '" + timestamp.toString() + "'";
    }

    void buildCriteria(Criteria criteria, InstanceFilter instanceFilter) {
        Object object;
        List list;
        Criteria criteria2 = criteria.createCriteria("process");
        List list2 = instanceFilter.getPidFilter();
        if (list2 != null && list2.size() > 0) {
            list = Restrictions.disjunction();
            for (Object object2 : list2) {
                if (!instanceFilter.arePidsNegative()) {
                    list.add((Criterion)Restrictions.eq((String)"processId", (Object)object2));
                    continue;
                }
                list.add((Criterion)Restrictions.ne((String)"processId", (Object)object2));
            }
            criteria2.add((Criterion)list);
        }
        if ((list = instanceFilter.getIidFilter()) != null && list.size() > 0) {
            object = Restrictions.disjunction();
            for (String object3 : list) {
                object.add((Criterion)Restrictions.eq((String)"id", (Object)new Long(object3)));
            }
            criteria.add((Criterion)object);
        }
        if (instanceFilter.getNameFilter() != null) {
            criteria2.add((Criterion)Restrictions.like((String)"typeName", (Object)instanceFilter.getNameFilter().replaceAll("\\*", "%")));
        }
        if (instanceFilter.getNamespaceFilter() != null) {
            criteria2.add((Criterion)Restrictions.like((String)"typeNamespace", (Object)instanceFilter.getNamespaceFilter().replaceAll("\\*", "%")));
        }
        if (instanceFilter.getStatusFilter() != null) {
            Object object2;
            object = instanceFilter.convertFilterState();
            object2 = Restrictions.disjunction();
            Iterator bl = object.iterator();
            while (bl.hasNext()) {
                short s = (Short)bl.next();
                object2.add((Criterion)Restrictions.eq((String)"state", (Object)s));
            }
            criteria.add((Criterion)object2);
        }
        if (instanceFilter.getStartedDateFilter() != null) {
            for (Object object2 : instanceFilter.getStartedDateFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(criteria, (String)object2, "created");
            }
        }
        if (instanceFilter.getLastActiveDateFilter() != null) {
            for (Object object2 : instanceFilter.getLastActiveDateFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(criteria, object2, "lastActiveTime");
            }
        }
        if (instanceFilter.getPropertyValuesFilter() != null) {
            object = criteria.createCriteria("correlationSets").createCriteria("properties");
            for (Map.Entry entry : instanceFilter.getPropertyValuesFilter().entrySet()) {
                String string = (String)entry.getKey();
                if (string.startsWith("{")) {
                    String string2 = string.substring(1, string.lastIndexOf("}"));
                    string = string.substring(string.lastIndexOf("}") + 1, string.length());
                    object.add((Criterion)Restrictions.eq((String)"name", (Object)string)).add((Criterion)Restrictions.eq((String)"namespace", (Object)string2)).add((Criterion)Restrictions.eq((String)"value", entry.getValue()));
                    continue;
                }
                object.add((Criterion)Restrictions.eq((String)"name", entry.getKey())).add((Criterion)Restrictions.eq((String)"value", entry.getValue()));
            }
        }
        if (instanceFilter.orders != null) {
            for (Object object2 : instanceFilter.orders) {
                boolean bl;
                boolean bl2 = true;
                Object object3 = object2;
                if (((String)object2).startsWith("+") || ((String)object2).startsWith("-")) {
                    object3 = ((String)object2).substring(1, ((String)object2).length());
                    if (((String)object2).startsWith("-")) {
                        bl = false;
                    }
                }
                if ("name".equals(object3)) {
                    if (bl) {
                        criteria2.addOrder(Property.forName((String)"typeName").asc());
                        continue;
                    }
                    criteria2.addOrder(Property.forName((String)"typeName").desc());
                    continue;
                }
                if ("namespace".equals(object3)) {
                    if (bl) {
                        criteria2.addOrder(Property.forName((String)"typeNamespace").asc());
                        continue;
                    }
                    criteria2.addOrder(Property.forName((String)"typeNamespace").desc());
                    continue;
                }
                if ("pid".equals(object3)) {
                    if (bl) {
                        criteria2.addOrder(Property.forName((String)"processId").asc());
                        continue;
                    }
                    criteria2.addOrder(Property.forName((String)"processId").desc());
                    continue;
                }
                if ("version".equals(object3)) {
                    if (bl) {
                        criteria2.addOrder(Property.forName((String)"version").asc());
                        continue;
                    }
                    criteria2.addOrder(Property.forName((String)"version").desc());
                    continue;
                }
                if ("status".equals(object3)) {
                    if (bl) {
                        criteria.addOrder(Property.forName((String)"state").asc());
                        continue;
                    }
                    criteria.addOrder(Property.forName((String)"state").desc());
                    continue;
                }
                if ("started".equals(object3)) {
                    if (bl) {
                        criteria.addOrder(Property.forName((String)"created").asc());
                        continue;
                    }
                    criteria.addOrder(Property.forName((String)"created").desc());
                    continue;
                }
                if (!"last-active".equals(object3)) continue;
                if (bl) {
                    criteria.addOrder(Property.forName((String)"lastActiveTime").asc());
                    continue;
                }
                criteria.addOrder(Property.forName((String)"lastActiveTime").desc());
            }
        }
        if (instanceFilter.getLimit() > 0) {
            criteria.setMaxResults(instanceFilter.getLimit());
        }
    }

    void buildCriteria(Criteria criteria, BpelEventFilter bpelEventFilter) {
        if (bpelEventFilter.getTypeFilter() != null) {
            criteria.add((Criterion)Restrictions.like((String)"type", (Object)bpelEventFilter.getTypeFilter().replace('*', '%')));
        }
        if (bpelEventFilter.getTimestampFilter() != null) {
            for (Filter.Restriction restriction : bpelEventFilter.getTimestampFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(criteria, restriction.op, (Date)restriction.value, "tstamp");
            }
        }
        if (bpelEventFilter.limit > 0) {
            criteria.setMaxResults(bpelEventFilter.limit);
        }
    }

    void addScopeFilter(Criteria criteria, String string) {
        criteria.add((Criterion)Restrictions.eq((String)"", (Object)string));
    }

    static void addFilterOnPrefixedDate(Criteria criteria, String string, String string2) {
        Date date = null;
        try {
            date = CriteriaBuilder.parseDateExpression(CriteriaBuilder.getDateWithoutOp(string));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        CriteriaBuilder.addFilterOnPrefixedDate(criteria, string, date, string2);
    }

    private static Date parseDateExpression(String string) throws ParseException {
        if (string.toLowerCase().startsWith("-") && string.length() > 1) {
            return RelativeDateParser.parseRelativeDate((String)string.substring(1));
        }
        return ISO8601DateParser.parse((String)string);
    }

    static void addFilterOnPrefixedDate(Criteria criteria, String string, Date date, String string2) {
        if (string.startsWith("=")) {
            criteria.add((Criterion)Restrictions.eq((String)string2, (Object)date));
        } else if (string.startsWith("<=")) {
            criteria.add((Criterion)Restrictions.le((String)string2, (Object)date));
        } else if (string.startsWith(">=")) {
            criteria.add((Criterion)Restrictions.ge((String)string2, (Object)date));
        } else if (string.startsWith("<")) {
            criteria.add((Criterion)Restrictions.lt((String)string2, (Object)date));
        } else if (string.startsWith(">")) {
            criteria.add((Criterion)Restrictions.gt((String)string2, (Object)date));
        }
    }

    private static String getDateWithoutOp(String string) {
        return Filter.getDateWithoutOp((String)string);
    }
}

