/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel.hobj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.usertype.UserType;

public class GZipDataType
implements UserType {
    private static final Log log = LogFactory.getLog(GZipDataType.class);
    public static final int[] SQL_TYPES = new int[]{2004};
    public static final Class RETURNED_CLASS = new byte[0].getClass();
    public static final byte[] GZIP_PREFIX = new byte[]{1, 2, 3, 4, 3, 2, 1, 0};
    private static long _totalBytesBefore = 0L;
    private static long _totalBytesAfter = 0L;
    private static volatile long _lastLogTime = 0L;
    private static final Object STATS_LOCK = new Object();
    private static volatile boolean _compressionEnabled = System.getProperty("org.apache.ode.daohib.bpel.hobj.GZipDataType.enabled", "true").equalsIgnoreCase("true");

    public Object assemble(Serializable cached, Object owner) {
        return cached;
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        return ((byte[])value).clone();
    }

    public boolean equals(Object x, Object y) {
        byte[] buf1 = (byte[])x;
        byte[] buf2 = (byte[])y;
        if (buf1 == buf2) {
            return true;
        }
        if (buf1 == null && buf2 != null) {
            return false;
        }
        if (buf1 != null && buf2 == null) {
            return false;
        }
        if (buf1.length != buf2.length) {
            return false;
        }
        for (int i = 0; i < buf1.length; ++i) {
            if (buf1[i] == buf2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode(Object x) {
        if (x == null) {
            return 0;
        }
        byte[] buf = (byte[])x;
        int hash = 0;
        for (int i = 0; i < buf.length; ++i) {
            hash += buf[i];
        }
        return hash;
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws SQLException {
        if (names.length != 1) {
            throw new IllegalStateException("Expected a single column name instead of " + names.length);
        }
        byte[] buf = rs.getBytes(names[0]);
        if (buf == null) {
            return null;
        }
        if (buf.length >= GZIP_PREFIX.length) {
            boolean gzip = true;
            for (int i = 0; i < GZIP_PREFIX.length; ++i) {
                if (buf[i] == GZIP_PREFIX[i]) continue;
                gzip = false;
                break;
            }
            if (gzip) {
                buf = GZipDataType.gunzip(new ByteArrayInputStream(buf, GZIP_PREFIX.length, buf.length - GZIP_PREFIX.length));
            }
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullSafeSet(PreparedStatement st, Object value, int index) throws SQLException {
        byte[] buf = (byte[])value;
        if (buf != null) {
            long now;
            Object baos;
            Object object = STATS_LOCK;
            synchronized (object) {
                if (_totalBytesBefore > Integer.MAX_VALUE) {
                    _totalBytesAfter = _totalBytesAfter * 100L / _totalBytesBefore;
                    _totalBytesBefore = 100L;
                }
                _totalBytesBefore += (long)buf.length;
            }
            if (buf != null && buf.length > 100 && _compressionEnabled) {
                baos = new ByteArrayOutputStream(buf.length);
                for (int i = 0; i < GZIP_PREFIX.length; ++i) {
                    ((ByteArrayOutputStream)baos).write(GZIP_PREFIX[i]);
                }
                GZipDataType.gzip((byte[])value, (OutputStream)baos);
                byte[] zipped = ((ByteArrayOutputStream)baos).toByteArray();
                if (zipped.length * 100 / buf.length < 99) {
                    buf = zipped;
                }
            }
            baos = STATS_LOCK;
            synchronized (baos) {
                _totalBytesAfter += (long)buf.length;
            }
            if (log.isDebugEnabled() && _lastLogTime + 5000L < (now = System.currentTimeMillis())) {
                log.debug((Object)("Average compression ratio: " + _totalBytesAfter * 100L / _totalBytesBefore + "%"));
                _lastLogTime = now;
            }
        }
        st.setBytes(index, buf);
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public Class returnedClass() {
        return RETURNED_CLASS;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public static void gzip(byte[] content, OutputStream out) {
        try {
            GZIPOutputStream zip = new GZIPOutputStream(out);
            zip.write(content, 0, content.length);
            zip.finish();
            zip.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] gunzip(InputStream input) {
        try {
            int len;
            GZIPInputStream unzip = new GZIPInputStream(input);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
            byte[] buf = new byte[4096];
            while ((len = unzip.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            unzip.close();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

