/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.MessageDaoImpl;
import org.apache.ode.daohib.bpel.PartnerLinkDAOImpl;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HMessage;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageExchangeDaoImpl
extends HibernateDao
implements MessageExchangeDAO {
    private static final Log __log = LogFactory.getLog(MessageExchangeDaoImpl.class);
    private HMessageExchange _hself;
    private ProcessDAO _externalProcess;
    private ProcessInstanceDAO _externalInstance;

    public MessageExchangeDaoImpl(SessionManager sm, HMessageExchange mex) {
        super(sm, mex);
        this.entering("MessageExchangeDaoImpl.MessageExchangeDaoImpl");
        this._hself = mex;
    }

    public String getMessageExchangeId() {
        return this._hself.getId().toString();
    }

    public MessageDAO getResponse() {
        this.entering("MessageExchangeDaoImpl.getResponse");
        return this._hself.getResponse() == null ? null : new MessageDaoImpl(this._sm, this._hself.getResponse());
    }

    public Date getCreateTime() {
        return this._hself.getInsertTime();
    }

    public void setCreateTime(Date createTime) {
        this._hself.setInsertTime(createTime);
    }

    public MessageDAO getRequest() {
        this.entering("MessageExchangeDaoImpl.getRequest");
        return this._hself.getRequest() == null ? null : new MessageDaoImpl(this._sm, this._hself.getRequest());
    }

    public String getOperation() {
        return this._hself.getOperationName();
    }

    public QName getPortType() {
        return this._hself.getPortType() == null ? null : QName.valueOf(this._hself.getPortType());
    }

    public void setPortType(QName porttype) {
        this.entering("MessageExchangeDaoImpl.setPortType");
        this._hself.setPortType(porttype == null ? null : porttype.toString());
        this.update();
    }

    public void setStatus(String status) {
        this.entering("MessageExchangeDaoImpl.setStatus");
        this._hself.setState(status);
        this.update();
    }

    public String getStatus() {
        return this._hself.getState();
    }

    public MessageDAO createMessage(QName type) {
        this.entering("MessageExchangeDaoImpl.createMessage");
        HMessage message = new HMessage();
        message.setType(type == null ? null : type.toString());
        message.setCreated(new Date());
        message.setMessageExchange(this._hself);
        this.getSession().save((Object)message);
        return new MessageDaoImpl(this._sm, message);
    }

    public void setRequest(MessageDAO msg) {
        this.entering("MessageExchangeDaoImpl.setRequest");
        this._hself.setRequest(msg == null ? null : (HMessage)((MessageDaoImpl)msg).getHibernateObj());
        this.update();
    }

    public void setResponse(MessageDAO msg) {
        this.entering("MessageExchangeDaoImpl.setResponse");
        this._hself.setResponse(msg == null ? null : (HMessage)((MessageDaoImpl)msg).getHibernateObj());
        this.update();
    }

    public int getPartnerLinkModelId() {
        return this._hself.getPartnerLinkModelId();
    }

    public void setPartnerLinkModelId(int modelId) {
        this.entering("MessageExchangeDaoImpl.setPartnerLinkModelId");
        this._hself.setPartnerLinkModelId(modelId);
        this.update();
    }

    public String getCorrelationId() {
        return this._hself.getClientKey();
    }

    public void setCorrelationId(String clientKey) {
        this.entering("MessageExchangeDaoImpl.setCorrelationId");
        this._hself.setClientKey(clientKey);
        this.update();
    }

    public void setPattern(String pattern) {
        this.entering("MessageExchangeDaoImpl.setPattern");
        this._hself.setPattern(pattern);
        this.update();
    }

    public void setOperation(String opname) {
        this.entering("MessageExchangeDaoImpl.setOperation");
        this._hself.setOperationName(opname);
        this.update();
    }

    public void setEPR(Element source) {
        this.entering("MessageExchangeDaoImpl.setEPR");
        if (source == null) {
            this._hself.setEndpoint(null);
        } else {
            this._hself.setEndpoint(DOMUtils.domToBytes((Element)source));
        }
        this.getSession().saveOrUpdate((Object)this._hself);
    }

    public Element getEPR() {
        this.entering("MessageExchangeDaoImpl.getEPR");
        byte[] endpoint = this._hself.getEndpoint();
        if (endpoint == null) {
            return null;
        }
        try {
            return DOMUtils.stringToDOM((byte[])endpoint);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setCallbackEPR(Element source) {
        this.entering("MessageExchangeDaoImpl.setCallbackEPR");
        if (source == null) {
            this._hself.setCallbackEndpoint(null);
        } else {
            this._hself.setCallbackEndpoint(DOMUtils.domToBytes((Element)source));
        }
        this.getSession().saveOrUpdate((Object)this._hself);
    }

    public Element getCallbackEPR() {
        this.entering("MessageExchangeDaoImpl.getCallbackEPR");
        byte[] endpoint = this._hself.getCallbackEndpoint();
        if (endpoint == null) {
            return null;
        }
        try {
            return DOMUtils.stringToDOM((byte[])endpoint);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getPattern() {
        return this._hself.getPattern();
    }

    public String getChannel() {
        return this._hself.getChannelName();
    }

    public void setChannel(String channel) {
        this.entering("MessageExchangeDaoImpl.setChannel");
        this._hself.setChannelName(channel);
        this.update();
    }

    public boolean getPropagateTransactionFlag() {
        return false;
    }

    public QName getFault() {
        return this._hself.getFault() == null ? null : QName.valueOf(this._hself.getFault());
    }

    public void setFault(QName faultType) {
        this.entering("MessageExchangeDaoImpl.setFault");
        this._hself.setFault(faultType == null ? null : faultType.toString());
        this.update();
    }

    public String getFaultExplanation() {
        return this._hself.getFaultExplanation();
    }

    public void setFaultExplanation(String explanation) {
        this.entering("MessageExchangeDaoImpl.setFaultExplanation");
        this._hself.setFaultExplanation(explanation);
        this.update();
    }

    public void setCorrelationStatus(String cstatus) {
        this.entering("MessageExchangeDaoImpl.setCorrelationStatus");
        this._hself.setCorrelationStatus(cstatus);
        this.update();
    }

    public String getCorrelationStatus() {
        return this._hself.getCorrelationStatus();
    }

    public ProcessDAO getProcess() {
        this.entering("MessageExchangeDaoImpl.getProcess");
        if (this._externalProcess != null) {
            return this._externalProcess;
        }
        return this._hself.getProcess() == null ? null : new ProcessDaoImpl(this._sm, this._hself.getProcess());
    }

    public void setProcess(ProcessDAO process) {
        this.entering("MessageExchangeDaoImpl.setProcess");
        if (process == null || process instanceof ProcessDaoImpl) {
            this._hself.setProcess(process == null ? null : (HProcess)((ProcessDaoImpl)process).getHibernateObj());
            this.update();
        } else {
            this._externalProcess = process;
        }
    }

    public void setInstance(ProcessInstanceDAO instance) {
        this.entering("MessageExchangeDaoImpl.setInstance");
        if (instance == null || instance instanceof ProcessInstanceDaoImpl) {
            this._hself.setInstance(instance == null ? null : (HProcessInstance)((ProcessInstanceDaoImpl)instance).getHibernateObj());
            this.update();
        } else {
            this._externalInstance = instance;
        }
    }

    public ProcessInstanceDAO getInstance() {
        this.entering("MessageExchangeDaoImpl.getInstance");
        if (this._externalInstance != null) {
            return this._externalInstance;
        }
        return this._hself.getInstance() == null ? null : new ProcessInstanceDaoImpl(this._sm, this._hself.getInstance());
    }

    public char getDirection() {
        return this._hself.getDirection();
    }

    public QName getCallee() {
        String callee = this._hself.getCallee();
        return callee == null ? null : QName.valueOf(callee);
    }

    public void setCallee(QName callee) {
        this.entering("MessageExchangeDaoImpl.setCallee");
        this._hself.setCallee(callee == null ? null : callee.toString());
        this.update();
    }

    public String getProperty(String key) {
        this.entering("MessageExchangeDaoImpl.getProperty");
        return this._hself.getProperties().get(key);
    }

    public void setProperty(String key, String value) {
        this.entering("MessageExchangeDaoImpl.setProperty");
        this._hself.getProperties().put(key, value);
        this.update();
    }

    public void setPartnerLink(PartnerLinkDAO plinkDAO) {
        this.entering("MessageExchangeDaoImpl.setPartnerLink");
        this._hself.setPartnerLink(((PartnerLinkDAOImpl)plinkDAO)._self);
        this.update();
    }

    public PartnerLinkDAO getPartnerLink() {
        this.entering("MessageExchangeDaoImpl.getPartnerLink");
        return new PartnerLinkDAOImpl(this._sm, this._hself.getPartnerLink());
    }

    public Set<String> getPropertyNames() {
        this.entering("MessageExchangeDaoImpl.getPropertyNames");
        return Collections.unmodifiableSet(this._hself.getProperties().keySet());
    }

    public String getPipedMessageExchangeId() {
        return this._hself.getPipedMessageExchangeId();
    }

    public void setPipedMessageExchangeId(String mexId) {
        this.entering("MessageExchangeDaoImpl.setPipedMessageExchangeId");
        this._hself.setPipedMessageExchangeId(mexId);
    }

    public int getSubscriberCount() {
        return this._hself.getSubscriberCount();
    }

    public void setSubscriberCount(int subscriberCount) {
        this._hself.setSubscriberCount(subscriberCount);
    }

    public void release(boolean doClean) {
        if (doClean) {
            this.deleteMessages();
        }
    }

    public void releasePremieMessages() {
        this.deleteByIds(HCorrelatorMessage.class, this.getSession().getNamedQuery("SELECT_CORMESSAGE_IDS_BY_MEX").setParameter("mex", (Object)this._hself).list());
    }

    public void incrementSubscriberCount() {
        this._hself.incrementSubscriberCount();
    }

    public void deleteMessages() {
        this.deleteByIds(HCorrelatorMessage.class, this.getSession().getNamedQuery("SELECT_CORMESSAGE_IDS_BY_MEX").setParameter("mex", (Object)this._hself).list());
        this.getSession().delete((Object)this._hself);
    }
}

