/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelationProperty;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CorrelationSetDaoImpl
extends HibernateDao
implements CorrelationSetDAO {
    private HCorrelationSet _correlationSet;

    public CorrelationSetDaoImpl(SessionManager sessionManager, HCorrelationSet correlationSet) {
        super(sessionManager, correlationSet);
        this.entering("CorrelationSetDaoImpl.CorrelationSetDaoImpl");
        this._correlationSet = correlationSet;
    }

    public Long getCorrelationSetId() {
        return this._correlationSet.getId();
    }

    public String getName() {
        return this._correlationSet.getName();
    }

    public ScopeDAO getScope() {
        this.entering("CorrelationSetDaoImpl.getScope");
        return new ScopeDaoImpl(this._sm, this._correlationSet.getScope());
    }

    public void setValue(QName[] names, CorrelationKey values) {
        this.entering("CorrelationSetDaoImpl.setValue");
        this._correlationSet.setValue(values.toCanonicalString());
        if (names != null) {
            if (this._correlationSet.getProperties() == null || this._correlationSet.getProperties().size() == 0) {
                for (int m = 0; m < names.length; ++m) {
                    HCorrelationProperty prop = new HCorrelationProperty(names[m], values.getValues()[m], this._correlationSet);
                    this.getSession().save((Object)prop);
                }
            } else {
                for (int m = 0; m < names.length; ++m) {
                    HCorrelationProperty prop = this.getProperty(names[m]);
                    if (prop == null) {
                        prop = new HCorrelationProperty(names[m], values.getValues()[m], this._correlationSet);
                    } else {
                        prop.setValue(values.getValues()[m]);
                    }
                    this.getSession().save((Object)prop);
                }
            }
        }
        this.getSession().update((Object)this._correlationSet);
    }

    public CorrelationKey getValue() {
        this.entering("CorrelationSetDaoImpl.getValue");
        if (this._correlationSet.getValue() != null) {
            return new CorrelationKey(this._correlationSet.getValue());
        }
        return null;
    }

    public Map<QName, String> getProperties() {
        this.entering("CorrelationSetDaoImpl.getProperties");
        HashMap<QName, String> result = new HashMap<QName, String>();
        for (HCorrelationProperty property : this._correlationSet.getProperties()) {
            result.put(property.getQName(), property.getValue());
        }
        return result;
    }

    public ProcessDAO getProcess() {
        return new ProcessDaoImpl(this._sm, this._correlationSet.getProcess());
    }

    public ProcessInstanceDAO getInstance() {
        return new ProcessInstanceDaoImpl(this._sm, this._correlationSet.getInstance());
    }

    private HCorrelationProperty getProperty(QName qName) {
        this.entering("CorrelationSetDaoImpl.getProperty");
        for (HCorrelationProperty property : this._correlationSet.getProperties()) {
            if (!qName.getLocalPart().equals(property.getName()) || !qName.getNamespaceURI().equals(property.getNamespace())) continue;
            return property;
        }
        return null;
    }
}

