/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.BpelDAOConnectionFactoryJDBC;
import org.apache.ode.daohib.DataSourceConnectionProvider;
import org.apache.ode.daohib.HibernateTransactionManagerLookup;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.BpelDAOConnectionImpl;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;

public class BpelDAOConnectionFactoryImpl
implements BpelDAOConnectionFactoryJDBC {
    private static final Log __log = LogFactory.getLog(BpelDAOConnectionFactoryImpl.class);
    protected SessionManager _sessionManager;
    private DataSource _ds;
    private TransactionManager _tm;
    private static final String DEFAULT_HIBERNATE_DIALECT = "org.hibernate.dialect.DerbyDialect";
    private static final HashMap<String, DialectFactory.VersionInsensitiveMapper> HIBERNATE_DIALECTS = new HashMap();

    public BpelDAOConnection getConnection() {
        try {
            return new BpelDAOConnectionImpl(this._sessionManager);
        }
        catch (HibernateException e) {
            __log.error((Object)"DbError", (Throwable)e);
            throw e;
        }
    }

    public void init(Properties initialProps) {
        if (this._ds == null) {
            String errmsg = "setDataSource() not called!";
            __log.fatal((Object)errmsg);
            throw new IllegalStateException(errmsg);
        }
        if (this._tm == null) {
            String errmsg = "setTransactionManager() not called!";
            __log.fatal((Object)errmsg);
            throw new IllegalStateException(errmsg);
        }
        if (initialProps == null) {
            initialProps = new Properties();
        }
        Properties properties = new Properties();
        for (Object prop : initialProps.keySet()) {
            properties.put(prop, initialProps.get(prop));
        }
        if (properties.containsKey("hibernate.connection.provider_class")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.connection.provider_class");
        }
        if (properties.containsKey("hibernate.transaction.manager_lookup_class")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.transaction.manager_lookup_class");
        }
        if (properties.containsKey("hibernate.session_factory_name")) {
            __log.warn((Object)"Ignoring user-specified Hibernate property: hibernate.session_factory_name");
        }
        properties.put("hibernate.connection.provider_class", DataSourceConnectionProvider.class.getName());
        properties.put("hibernate.transaction.manager_lookup_class", HibernateTransactionManagerLookup.class.getName());
        properties.put("hibernate.transaction.factory_class", "org.hibernate.transaction.JTATransactionFactory");
        properties.put("hibernate.current_session_context_class", "jta");
        if (properties.get("hibernate.dialect") == null) {
            try {
                properties.put("hibernate.dialect", this.guessDialect(this._ds));
            }
            catch (Exception ex) {
                String errmsg = "Unable to detect Hibernate dialect!";
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)errmsg, (Throwable)ex);
                }
                __log.error((Object)errmsg);
            }
        }
        String level = System.getProperty("ode.connection.isolation", "2");
        properties.put("hibernate.connection.isolation", level);
        if (__log.isDebugEnabled()) {
            Enumeration<?> names = properties.propertyNames();
            __log.debug((Object)"Properties passed to Hibernate:");
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                __log.debug((Object)(name + "=" + properties.getProperty(name)));
            }
        }
        this._sessionManager = this.createSessionManager(properties, this._ds, this._tm);
    }

    protected SessionManager createSessionManager(Properties properties, DataSource ds, TransactionManager tm) {
        return new SessionManager(properties, ds, tm);
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessDialect(DataSource dataSource) throws Exception {
        String dialect = null;
        Connection conn = dataSource.getConnection();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            if (metaData != null) {
                String dbProductName = metaData.getDatabaseProductName();
                int dbMajorVer = metaData.getDatabaseMajorVersion();
                __log.info((Object)("Using database " + dbProductName + " major version " + dbMajorVer));
                DialectFactory.DatabaseDialectMapper mapper = (DialectFactory.DatabaseDialectMapper)HIBERNATE_DIALECTS.get(dbProductName);
                if (mapper != null) {
                    dialect = mapper.getDialectClass(dbMajorVer);
                } else {
                    Dialect hbDialect = DialectFactory.determineDialect((String)dbProductName, (int)dbMajorVer);
                    if (hbDialect != null) {
                        dialect = hbDialect.getClass().getName();
                    }
                }
            }
        }
        finally {
            conn.close();
        }
        if (dialect == null) {
            __log.info((Object)"Cannot determine hibernate dialect for this database: using the default one.");
            dialect = DEFAULT_HIBERNATE_DIALECT;
        }
        return dialect;
    }

    public void setDataSource(DataSource ds) {
        this._ds = ds;
    }

    public DataSource getDataSource() {
        return this._ds;
    }

    public void setTransactionManager(Object tm) {
        this._tm = (TransactionManager)tm;
    }

    public void setUnmanagedDataSource(DataSource ds) {
    }

    static {
        HIBERNATE_DIALECTS.put("Apache Derby", new DialectFactory.VersionInsensitiveMapper(DEFAULT_HIBERNATE_DIALECT));
        HIBERNATE_DIALECTS.put("INGRES", new DialectFactory.VersionInsensitiveMapper("org.hibernate.dialect.IngresDialect"));
    }
}

