/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.hibernate.Query;

class MessageRouteDaoImpl
extends HibernateDao
implements MessageRouteDAO {
    private static final String LOCK_INSTANCE = "update " + HProcessInstance.class.getName() + " set lock=lock+1 where id=?";
    private HCorrelatorSelector _selector;
    private boolean _locked = false;

    public MessageRouteDaoImpl(SessionManager sessionManager, HCorrelatorSelector hCorrelatorSelector) {
        super(sessionManager, hCorrelatorSelector);
        this.entering("MessageRouteDaoImpl.MessageRouteDaoImpl");
        this._selector = hCorrelatorSelector;
    }

    public ProcessInstanceDAO getTargetInstance() {
        this.entering("MessageRouteDaoImpl.getTargetInstance");
        if (!this._locked) {
            Query query = this.getSession().createQuery(LOCK_INSTANCE);
            query.setLong(0, this._selector.getInstance().getId().longValue());
            query.executeUpdate();
            this._locked = true;
        }
        return new ProcessInstanceDaoImpl(this._sm, this._selector.getInstance());
    }

    public String getGroupId() {
        this.entering("MessageRouteDaoImpl.getGroupId");
        return this._selector.getGroupId();
    }

    public int getIndex() {
        this.entering("MessageRouteDaoImpl.getIndex");
        return this._selector.getIndex();
    }

    public String getRoute() {
        return this._selector.getRoute();
    }

    public CorrelationKeySet getCorrelationKeySet() {
        return new CorrelationKeySet(this._selector.getCorrelationKey());
    }

    public void setCorrelationKeySet(CorrelationKeySet correlationKeySet) {
        this._selector.setCorrelationKey(correlationKeySet.toCanonicalString());
    }

    public void setCorrelationKey(CorrelationKey correlationKey) {
        this._selector.setCorrelationKey(correlationKey.toCanonicalString());
    }

    public CorrelationKey getCorrelationKey() {
        return new CorrelationKey(this._selector.getCorrelationKey());
    }
}

