/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.FilteredInstanceDeletable;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ProcessManagementDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.CorrelationSetDaoImpl;
import org.apache.ode.daohib.bpel.CriteriaBuilder;
import org.apache.ode.daohib.bpel.MessageExchangeDaoImpl;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.ProcessManagementDaoImpl;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.ql.HibernateInstancesQueryCompiler;
import org.apache.ode.ql.eval.skel.CommandEvaluator;
import org.apache.ode.ql.tree.Builder;
import org.apache.ode.ql.tree.BuilderFactory;
import org.apache.ode.ql.tree.nodes.Node;
import org.apache.ode.ql.tree.nodes.Query;
import org.apache.ode.utils.SerializableUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunctionEx;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelDAOConnectionImpl
implements BpelDAOConnection,
FilteredInstanceDeletable {
    private static final Log __log = LogFactory.getLog(BpelDAOConnectionImpl.class);
    protected SessionManager _sm;

    public BpelDAOConnectionImpl(SessionManager sessionManager) {
        this._sm = sessionManager;
    }

    protected Session getSession() {
        return this._sm.getSession();
    }

    public MessageExchangeDAO createMessageExchange(char c) {
        HMessageExchange hMessageExchange = new HMessageExchange();
        hMessageExchange.setDirection(c);
        this.getSession().save((Object)hMessageExchange);
        return new MessageExchangeDaoImpl(this._sm, hMessageExchange);
    }

    public MessageExchangeDAO getMessageExchange(String string) {
        HMessageExchange hMessageExchange = (HMessageExchange)this.getSession().get(HMessageExchange.class, (Serializable)new Long(string));
        return hMessageExchange == null ? null : new MessageExchangeDaoImpl(this._sm, hMessageExchange);
    }

    public ProcessDAO createProcess(QName qName, QName qName2, String string, long l) {
        HProcess hProcess = new HProcess();
        hProcess.setProcessId(qName.toString());
        hProcess.setTypeName(qName2.getLocalPart());
        hProcess.setTypeNamespace(qName2.getNamespaceURI());
        hProcess.setDeployDate(new Date());
        hProcess.setGuid(string);
        hProcess.setVersion(l);
        this.getSession().save((Object)hProcess);
        return new ProcessDaoImpl(this._sm, hProcess);
    }

    public ProcessDAO createTransientProcess(Serializable serializable) {
        HProcess hProcess = new HProcess();
        hProcess.setId((Long)serializable);
        return new ProcessDaoImpl(this._sm, hProcess);
    }

    public ProcessDAO getProcess(QName qName) {
        try {
            Criteria criteria = this.getSession().createCriteria(HProcess.class);
            criteria.add((Criterion)Expression.eq((String)"processId", (Object)qName.toString()));
            HProcess hProcess = (HProcess)criteria.uniqueResult();
            return hProcess == null ? null : new ProcessDaoImpl(this._sm, hProcess);
        }
        catch (HibernateException hibernateException) {
            __log.error((Object)"DbError", (Throwable)hibernateException);
            throw hibernateException;
        }
    }

    public void close() {
    }

    public ProcessInstanceDAO getInstance(Long l) {
        return BpelDAOConnectionImpl._getInstance(this._sm, this.getSession(), l);
    }

    public int getNumInstances(QName qName) {
        ProcessDAO processDAO = this.getProcess(qName);
        if (processDAO != null) {
            return processDAO.getNumInstances();
        }
        return -1;
    }

    public ScopeDAO getScope(Long l) {
        return BpelDAOConnectionImpl._getScope(this._sm, this.getSession(), l);
    }

    public Collection<ProcessInstanceDAO> instanceQuery(InstanceFilter instanceFilter) {
        if (instanceFilter.getLimit() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProcessInstanceDAO> arrayList = new ArrayList<ProcessInstanceDAO>();
        Iterator<HProcessInstance> iterator = BpelDAOConnectionImpl._instanceQuery(this.getSession(), false, instanceFilter);
        while (iterator.hasNext()) {
            arrayList.add(new ProcessInstanceDaoImpl(this._sm, iterator.next()));
        }
        return arrayList;
    }

    public int deleteInstances(InstanceFilter instanceFilter, Set<ProcessConf.CLEANUP_CATEGORY> set) {
        if (instanceFilter.getLimit() == 0) {
            return 0;
        }
        List<HProcessInstance> list = BpelDAOConnectionImpl._instanceQueryForList(this.getSession(), false, instanceFilter);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Collected " + list.size() + " instances to delete."));
        }
        if (!list.isEmpty()) {
            ProcessDaoImpl processDaoImpl = (ProcessDaoImpl)this.createTransientProcess(list.get(0).getProcessId());
            return processDaoImpl.deleteInstances(list, set);
        }
        return 0;
    }

    static Iterator<HProcessInstance> _instanceQuery(Session session, boolean bl, InstanceFilter instanceFilter) {
        return BpelDAOConnectionImpl._instanceQueryForList(session, bl, instanceFilter).iterator();
    }

    private static List<HProcessInstance> _instanceQueryForList(Session session, boolean bl, InstanceFilter instanceFilter) {
        Criteria criteria = session.createCriteria(HProcessInstance.class);
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder();
        criteriaBuilder.buildCriteria(criteria, instanceFilter);
        criteria.setFetchMode("fault", FetchMode.JOIN);
        return criteria.list();
    }

    static ProcessInstanceDAO _getInstance(SessionManager sessionManager, Session session, Long l) {
        HProcessInstance hProcessInstance = (HProcessInstance)session.get(HProcessInstance.class, (Serializable)l);
        return hProcessInstance != null ? new ProcessInstanceDaoImpl(sessionManager, hProcessInstance) : null;
    }

    static ScopeDAO _getScope(SessionManager sessionManager, Session session, Long l) {
        HScope hScope = (HScope)session.get(HScope.class, (Serializable)l);
        return hScope != null ? new ScopeDaoImpl(sessionManager, hScope) : null;
    }

    public void insertBpelEvent(BpelEvent bpelEvent, ProcessDAO processDAO, ProcessInstanceDAO processInstanceDAO) {
        BpelDAOConnectionImpl._insertBpelEvent(this._sm.getSession(), bpelEvent, processDAO, processInstanceDAO);
    }

    static void _insertBpelEvent(Session session, BpelEvent bpelEvent, ProcessDAO processDAO, ProcessInstanceDAO processInstanceDAO) {
        HBpelEvent hBpelEvent = new HBpelEvent();
        hBpelEvent.setTstamp(new Timestamp(System.currentTimeMillis()));
        hBpelEvent.setType(BpelEvent.eventName((BpelEvent)bpelEvent));
        hBpelEvent.setDetail(bpelEvent.toString());
        if (processDAO != null) {
            hBpelEvent.setProcess((HProcess)((ProcessDaoImpl)processDAO).getHibernateObj());
        }
        if (processInstanceDAO != null) {
            hBpelEvent.setInstance((HProcessInstance)((ProcessInstanceDaoImpl)processInstanceDAO).getHibernateObj());
        }
        if (bpelEvent instanceof ScopeEvent) {
            hBpelEvent.setScopeId(((ScopeEvent)bpelEvent).getScopeId());
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(bpelEvent);
            objectOutputStream.flush();
            HLargeData hLargeData = new HLargeData(byteArrayOutputStream.toByteArray());
            hBpelEvent.setData(hLargeData);
            session.save((Object)hLargeData);
        }
        catch (Throwable throwable) {
            __log.fatal((Object)"InternalError: BpelEvent serialization failed.", throwable);
        }
        session.save((Object)hBpelEvent);
    }

    public List<Date> bpelEventTimelineQuery(InstanceFilter instanceFilter, BpelEventFilter bpelEventFilter) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder();
        Criteria criteria = this.getSession().createCriteria(HBpelEvent.class);
        if (instanceFilter != null) {
            criteriaBuilder.buildCriteria(criteria, bpelEventFilter);
        }
        if (instanceFilter != null) {
            criteriaBuilder.buildCriteria(criteria.createCriteria("instance"), instanceFilter);
        }
        criteria.setFetchMode("tstamp", FetchMode.EAGER);
        criteria.setProjection((Projection)Projections.property((String)"tstamp"));
        return criteria.list();
    }

    public List<BpelEvent> bpelEventQuery(InstanceFilter instanceFilter, BpelEventFilter bpelEventFilter) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder();
        Criteria criteria = this.getSession().createCriteria(HBpelEvent.class);
        if (bpelEventFilter != null) {
            criteriaBuilder.buildCriteria(criteria, bpelEventFilter);
        }
        if (instanceFilter != null) {
            criteriaBuilder.buildCriteria(criteria.createCriteria("instance"), instanceFilter);
        }
        List list = criteria.list();
        ArrayList<BpelEvent> arrayList = new ArrayList<BpelEvent>(list.size());
        try {
            CollectionsX.transformEx(arrayList, (Collection)list, (UnaryFunctionEx)new UnaryFunctionEx<HBpelEvent, BpelEvent>(){

                public BpelEvent apply(HBpelEvent hBpelEvent) throws Exception {
                    return (BpelEvent)SerializableUtils.toObject((byte[])hBpelEvent.getData().getBinary(), (ClassLoader)BpelEvent.class.getClassLoader());
                }
            });
        }
        catch (Exception exception) {
            __log.fatal((Object)"Internal error: unable to transform HBpelEvent", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        return arrayList;
    }

    public Collection<ProcessInstanceDAO> instanceQuery(String string) {
        Builder builder = BuilderFactory.getInstance().createBuilder();
        Node node = builder.build((Object)string);
        HibernateInstancesQueryCompiler hibernateInstancesQueryCompiler = new HibernateInstancesQueryCompiler();
        CommandEvaluator<List, Session> commandEvaluator = hibernateInstancesQueryCompiler.compile((Query)node);
        List list = (List)commandEvaluator.evaluate((Object)this.getSession());
        ArrayList<ProcessInstanceDAO> arrayList = new ArrayList<ProcessInstanceDAO>(list.size());
        for (HProcessInstance hProcessInstance : list) {
            arrayList.add(this.getInstance(hProcessInstance.getId()));
        }
        return arrayList;
    }

    public Map<Long, Collection<CorrelationSetDAO>> getCorrelationSets(Collection<ProcessInstanceDAO> collection) {
        if (collection.size() == 0) {
            return new HashMap<Long, Collection<CorrelationSetDAO>>();
        }
        Object[] objectArray = new Long[collection.size()];
        int n = 0;
        for (ProcessInstanceDAO object2 : collection) {
            objectArray[n] = object2.getInstanceId();
            ++n;
        }
        List list = this.getSession().getNamedQuery("SELECT_CORSETS_BY_INSTANCES").setParameterList("instances", objectArray).list();
        HashMap<Long, Collection<CorrelationSetDAO>> hashMap = new HashMap<Long, Collection<CorrelationSetDAO>>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HCorrelationSet hCorrelationSet = (HCorrelationSet)iterator.next();
            Long l = hCorrelationSet.getInstance().getId();
            ArrayList<CorrelationSetDaoImpl> arrayList = (ArrayList<CorrelationSetDaoImpl>)hashMap.get(l);
            if (arrayList == null) {
                arrayList = new ArrayList<CorrelationSetDaoImpl>();
                hashMap.put(l, arrayList);
            }
            arrayList.add(new CorrelationSetDaoImpl(this._sm, hCorrelationSet));
        }
        return hashMap;
    }

    public Collection<CorrelationSetDAO> getActiveCorrelationSets() {
        ArrayList<CorrelationSetDAO> arrayList = new ArrayList<CorrelationSetDAO>();
        List list = this.getSession().getNamedQuery("SELECT_CORSETS_BY_PROCESS_STATES").setParameter("states", (Object)20).list();
        for (HCorrelationSet hCorrelationSet : list) {
            arrayList.add(new CorrelationSetDaoImpl(this._sm, hCorrelationSet));
        }
        return arrayList;
    }

    public ProcessManagementDAO getProcessManagement() {
        return new ProcessManagementDaoImpl(this._sm);
    }
}

