/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel.ql;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.ql.StateComparator;
import org.apache.ode.ql.Compiler;
import org.apache.ode.ql.eval.skel.AbstractConjunction;
import org.apache.ode.ql.eval.skel.AbstractDisjunction;
import org.apache.ode.ql.eval.skel.AbstractEqualityEvaluator;
import org.apache.ode.ql.eval.skel.CommandEvaluator;
import org.apache.ode.ql.eval.skel.ConjunctionEvaluator;
import org.apache.ode.ql.eval.skel.DisjunctionEvaluator;
import org.apache.ode.ql.eval.skel.EqualityEvaluator;
import org.apache.ode.ql.eval.skel.GEEvaluator;
import org.apache.ode.ql.eval.skel.GreaterEvaluator;
import org.apache.ode.ql.eval.skel.INEvaluator;
import org.apache.ode.ql.eval.skel.LEEvaluator;
import org.apache.ode.ql.eval.skel.LessEvaluator;
import org.apache.ode.ql.eval.skel.LikeEvaluator;
import org.apache.ode.ql.eval.skel.OrderByEvaluator;
import org.apache.ode.ql.tree.Builder;
import org.apache.ode.ql.tree.BuilderFactory;
import org.apache.ode.ql.tree.nodes.Conjunction;
import org.apache.ode.ql.tree.nodes.Disjunction;
import org.apache.ode.ql.tree.nodes.Equality;
import org.apache.ode.ql.tree.nodes.Field;
import org.apache.ode.ql.tree.nodes.GE;
import org.apache.ode.ql.tree.nodes.Greater;
import org.apache.ode.ql.tree.nodes.Identifier;
import org.apache.ode.ql.tree.nodes.IdentifierToValueCMP;
import org.apache.ode.ql.tree.nodes.In;
import org.apache.ode.ql.tree.nodes.LE;
import org.apache.ode.ql.tree.nodes.Less;
import org.apache.ode.ql.tree.nodes.Like;
import org.apache.ode.ql.tree.nodes.Limit;
import org.apache.ode.ql.tree.nodes.LogicExprNode;
import org.apache.ode.ql.tree.nodes.LogicNode;
import org.apache.ode.ql.tree.nodes.Node;
import org.apache.ode.ql.tree.nodes.OrderBy;
import org.apache.ode.ql.tree.nodes.OrderByElement;
import org.apache.ode.ql.tree.nodes.OrderByType;
import org.apache.ode.ql.tree.nodes.Property;
import org.apache.ode.ql.tree.nodes.Query;
import org.apache.ode.ql.tree.nodes.Value;
import org.apache.ode.ql.tree.nodes.ValuesHelper;
import org.apache.ode.utils.ISO8601DateParser;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateInstancesQueryCompiler
extends Compiler<List, Session> {
    private static final String INSTANCE_ID_FIELD = "iid";
    private static final String PROCESS_ID_FIELD = "pid";
    private static final String PROCESS_NAME_FIELD = "name";
    private static final String PROCESS_NAMESPACE_FIELD = "namespace";
    private static final String INSTANCE_STATUS_FIELD = "status";
    private static final String INSTANCE_STARTED_FIELD = "started";
    private static final String INSTANCE_LAST_ACTIVE_FIELD = "last-active";
    private static final String INSTANCE_ID_DB_FIELD = "id";
    private static final String PROCESS_ID_DB_FIELD = "process.processId";
    private static final String PROCESS_NAME_DB_FIELD = "process.typeName";
    private static final String PROCESS_NAMESPACE_DB_FIELD = "process.typeNamespace";
    private static final String INSTANCE_STATUS_DB_FIELD = "state";
    private static final String PROPERTY_NS_DB_FIELD = "process.typeNamespace";
    private static final String PROPERTY_NAME_DB_FIELD = "property.name";
    private static final String PROPERTY_VALUE_DB_FIELD = "property.value";
    private static final String INSTANCE_STARTED_DB_FIELD = "created";
    private static final String INSTANCE_LAST_ACTIVE_DB_FIELD = "lastActiveTime";
    private static final String STATUS_ACTIVE = "active";
    private static final String STATUS_SUSPENDED = "suspended";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_COMPLETED = "completed";
    private static final String STATUS_TERMINATED = "terminated";
    private static final String STATUS_FAULTED = "failed";
    private static final Map<String, String> nodeIdentifierToDBField = new HashMap<String, String>(20);
    private boolean propertyInQuery;
    private boolean orderByStatus;
    private boolean orderByStatusDesc;

    private static String getDBField(String string) {
        String string2 = nodeIdentifierToDBField.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Unsupported field " + string);
        }
        return string2;
    }

    private void init() {
        this.propertyInQuery = false;
        this.orderByStatus = false;
        this.orderByStatusDesc = false;
    }

    public CommandEvaluator<List, Session> compile(Query query) {
        this.init();
        final OrderByEvaluator<Collection<Order>, Object> orderByEvaluator = query.getOrder() != null ? this.compileOrderBy(query.getOrder()) : null;
        final CommandEvaluator commandEvaluator = query.getChilds().size() == 0 ? null : this.compileEvaluator(query.getChilds().iterator().next());
        final boolean bl = this.propertyInQuery;
        final boolean bl2 = this.orderByStatus;
        final boolean bl3 = this.orderByStatusDesc;
        final Limit limit = query.getLimit();
        return new CommandEvaluator<List, Session>(){

            public List evaluate(Session session) {
                Collection collection;
                Criteria criteria = session.createCriteria(HProcessInstance.class).createAlias("process", "process");
                if (bl) {
                    criteria = criteria.createAlias("correlationSets", "property");
                }
                if (commandEvaluator != null) {
                    criteria.add((Criterion)commandEvaluator.evaluate(null));
                }
                if (orderByEvaluator != null) {
                    collection = (Collection)orderByEvaluator.evaluate(null);
                    for (Order order : collection) {
                        criteria.addOrder(order);
                    }
                }
                if (limit != null) {
                    criteria.setMaxResults(limit.getNumber());
                }
                collection = criteria.list();
                if (bl2) {
                    Collections.sort(collection, bl3 ? StateComparator.DESC : StateComparator.ASC);
                }
                return collection;
            }
        };
    }

    protected ConjunctionEvaluator<Criterion, Object> compileConjunction(Collection<CommandEvaluator> collection) {
        return new AbstractConjunction<Criterion, Object>(collection){

            public Criterion evaluate(Object object) {
                org.hibernate.criterion.Conjunction conjunction = Restrictions.conjunction();
                for (CommandEvaluator commandEvaluator : this.childs) {
                    conjunction.add((Criterion)commandEvaluator.evaluate(null));
                }
                return conjunction;
            }
        };
    }

    protected DisjunctionEvaluator<Criterion, Object> compileDisjunction(Collection<CommandEvaluator> collection) {
        return new AbstractDisjunction<Criterion, Object>(collection){

            public Criterion evaluate(Object object) {
                org.hibernate.criterion.Disjunction disjunction = Restrictions.disjunction();
                for (CommandEvaluator commandEvaluator : this.childs) {
                    disjunction.add((Criterion)commandEvaluator.evaluate(null));
                }
                return disjunction;
            }
        };
    }

    protected EqualityEvaluator<String, Criterion, Object> compileEqual(final Equality equality) {
        if (equality.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)equality.getIdentifier();
            return new EqualityEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object object) {
                    org.hibernate.criterion.Conjunction conjunction = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conjunction.add((Criterion)Restrictions.eq((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conjunction.add((Criterion)Restrictions.eq((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conjunction.add((Criterion)Restrictions.eq((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)equality.getValue().getValue()));
                    return conjunction;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        String string = equality.getIdentifier().getName();
        final Object object = equality.getValue().getValue();
        final String string2 = HibernateInstancesQueryCompiler.getDBField(string);
        if (INSTANCE_STATUS_FIELD.equals(string)) {
            return new FieldValueEquality(INSTANCE_STATUS_FIELD){

                public Criterion evaluate(Object object2) {
                    short s = 200;
                    org.hibernate.criterion.Disjunction disjunction = Restrictions.disjunction();
                    if (HibernateInstancesQueryCompiler.STATUS_ACTIVE.equals(object2)) {
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)0));
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)20));
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)10));
                    } else if (HibernateInstancesQueryCompiler.STATUS_SUSPENDED.equals(object2)) {
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)50));
                    } else if (HibernateInstancesQueryCompiler.STATUS_ERROR.equals(object)) {
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)s));
                    } else if (HibernateInstancesQueryCompiler.STATUS_COMPLETED.equals(object2)) {
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)30));
                    } else if (HibernateInstancesQueryCompiler.STATUS_TERMINATED.equals(object2)) {
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)60));
                    } else if (HibernateInstancesQueryCompiler.STATUS_FAULTED.equals(object2)) {
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)40));
                    } else {
                        disjunction.add((Criterion)Restrictions.eq((String)string2, (Object)s));
                    }
                    return disjunction;
                }
            };
        }
        return new DBFieldValueEq(string2, object);
    }

    public CommandEvaluator compileEvaluator(Object object) {
        if (object instanceof In) {
            return this.compileIn((In)object);
        }
        if (object instanceof Conjunction) {
            return this.compileConjunction(this.evaluate((LogicExprNode)object));
        }
        if (object instanceof Disjunction) {
            return this.compileDisjunction(this.evaluate((LogicExprNode)object));
        }
        if (object instanceof IdentifierToValueCMP) {
            return this.compileIdentifierToValueCMP((IdentifierToValueCMP)object);
        }
        throw new IllegalArgumentException("Unsupported node " + object.getClass());
    }

    protected CommandEvaluator<Criterion, Object> compileIdentifierToValueCMP(IdentifierToValueCMP identifierToValueCMP) {
        Identifier identifier = identifierToValueCMP.getIdentifier();
        if (identifier instanceof Field) {
            String string = identifier.getName();
            Value value = identifierToValueCMP.getValue();
            if (INSTANCE_ID_FIELD.equals(string)) {
                value.setValue((Object)Long.valueOf((String)value.getValue()));
            } else if (INSTANCE_STARTED_FIELD.equals(string) || INSTANCE_LAST_ACTIVE_FIELD.equals(string)) {
                try {
                    value.setValue((Object)ISO8601DateParser.parse((String)((String)value.getValue())));
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(parseException);
                }
            }
        }
        if (identifierToValueCMP instanceof Equality) {
            return this.compileEqual((Equality)identifierToValueCMP);
        }
        if (identifierToValueCMP instanceof Less) {
            return this.compileLess((Less)identifierToValueCMP);
        }
        if (identifierToValueCMP instanceof Greater) {
            return this.compileGreater((Greater)identifierToValueCMP);
        }
        if (identifierToValueCMP instanceof GE) {
            return this.compileGE((GE)identifierToValueCMP);
        }
        if (identifierToValueCMP instanceof LE) {
            return this.compileLE((LE)identifierToValueCMP);
        }
        if (identifierToValueCMP instanceof Like) {
            return this.compileLike((Like)identifierToValueCMP);
        }
        throw new IllegalArgumentException("Unsupported node " + identifierToValueCMP.getClass());
    }

    protected GEEvaluator<String, Criterion, Object> compileGE(final GE gE) {
        if (gE.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)gE.getIdentifier();
            return new GEEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object object) {
                    org.hibernate.criterion.Conjunction conjunction = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conjunction.add((Criterion)Restrictions.ge((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conjunction.add((Criterion)Restrictions.ge((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conjunction.add((Criterion)Restrictions.ge((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)gE.getValue().getValue()));
                    return conjunction;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        final String string = gE.getIdentifier().getName();
        final Object object = gE.getValue().getValue();
        if (INSTANCE_STATUS_FIELD.equals(string)) {
            throw new IllegalArgumentException("Field status is not supported.");
        }
        final String string2 = HibernateInstancesQueryCompiler.getDBField(string);
        return new GEEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object object2) {
                return Restrictions.ge((String)string2, (Object)object);
            }

            public String getIdentifier() {
                return string;
            }
        };
    }

    protected GreaterEvaluator<String, Criterion, Object> compileGreater(final Greater greater) {
        if (greater.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)greater.getIdentifier();
            return new GreaterEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object object) {
                    org.hibernate.criterion.Conjunction conjunction = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conjunction.add((Criterion)Restrictions.gt((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conjunction.add((Criterion)Restrictions.gt((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conjunction.add((Criterion)Restrictions.gt((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)greater.getValue().getValue()));
                    return conjunction;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        final String string = greater.getIdentifier().getName();
        final Object object = greater.getValue().getValue();
        if (INSTANCE_STATUS_FIELD.equals(string)) {
            throw new IllegalArgumentException("Field status is not supported.");
        }
        final String string2 = HibernateInstancesQueryCompiler.getDBField(string);
        return new GreaterEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object object2) {
                return Restrictions.gt((String)string2, (Object)object);
            }

            public String getIdentifier() {
                return string;
            }
        };
    }

    protected INEvaluator<String, Criterion, Object> compileIn(final In in) {
        Collection<Date> collection;
        if (in.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)in.getIdentifier();
            return new INEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object object) {
                    org.hibernate.criterion.Disjunction disjunction = Restrictions.disjunction();
                    String string = property.getNamespace();
                    String string2 = property.getName();
                    for (Value value : in.getValues()) {
                        org.hibernate.criterion.Conjunction conjunction = Restrictions.conjunction();
                        if (!StringUtils.isEmpty((String)property.getNamespace())) {
                            conjunction.add((Criterion)Restrictions.gt((String)"process.typeNamespace", (Object)string));
                        }
                        conjunction.add((Criterion)Restrictions.gt((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)string2));
                        conjunction.add((Criterion)Restrictions.gt((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)value.getValue()));
                        disjunction.add((Criterion)conjunction);
                    }
                    return disjunction;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        String string = in.getIdentifier().getName();
        if (INSTANCE_STATUS_FIELD.equals(string)) {
            short s = 200;
            final org.hibernate.criterion.Disjunction disjunction = Restrictions.disjunction();
            Collection collection2 = ValuesHelper.extract((Collection)in.getValues());
            if (collection2.contains(STATUS_ACTIVE)) {
                disjunction.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)0));
                disjunction.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)20));
                disjunction.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)10));
            }
            if (collection2.contains(STATUS_SUSPENDED)) {
                disjunction.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)50));
            }
            if (collection2.contains(STATUS_ERROR)) {
                disjunction.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)s));
            }
            if (collection2.contains(STATUS_COMPLETED)) {
                disjunction.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)30));
            }
            if (collection2.contains(STATUS_TERMINATED)) {
                disjunction.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)60));
            }
            if (collection2.contains(STATUS_FAULTED)) {
                disjunction.add((Criterion)Restrictions.eq((String)INSTANCE_STATUS_DB_FIELD, (Object)40));
            }
            return new INEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object object) {
                    return disjunction;
                }

                public String getIdentifier() {
                    return HibernateInstancesQueryCompiler.INSTANCE_STATUS_DB_FIELD;
                }
            };
        }
        Collection collection3 = in.getValues();
        if (INSTANCE_ID_FIELD.equals(string)) {
            collection = new ArrayList(collection3.size());
            for (Value value : collection3) {
                collection.add((Date)((Object)Long.valueOf((String)value.getValue())));
            }
        } else if (INSTANCE_STARTED_FIELD.equals(string) || INSTANCE_LAST_ACTIVE_FIELD.equals(string)) {
            collection = new ArrayList(collection3.size());
            try {
                for (Value value : collection3) {
                    collection.add(ISO8601DateParser.parse((String)((String)value.getValue())));
                }
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        } else {
            collection = ValuesHelper.extract((Collection)collection3);
        }
        final Iterator iterator = HibernateInstancesQueryCompiler.getDBField(string);
        return new INEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object object) {
                return Restrictions.in((String)iterator, (Collection)collection);
            }

            public String getIdentifier() {
                return iterator;
            }
        };
    }

    protected LEEvaluator<String, Criterion, Object> compileLE(final LE lE) {
        if (lE.getIdentifier() instanceof Property) {
            final Property property = (Property)lE.getIdentifier();
            return new LEEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object object) {
                    org.hibernate.criterion.Conjunction conjunction = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conjunction.add((Criterion)Restrictions.le((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conjunction.add((Criterion)Restrictions.le((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conjunction.add((Criterion)Restrictions.le((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)lE.getValue().getValue()));
                    return conjunction;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        final String string = lE.getIdentifier().getName();
        final Object object = lE.getValue().getValue();
        if (INSTANCE_STATUS_FIELD.equals(string)) {
            throw new IllegalArgumentException("Field status is not supported.");
        }
        final String string2 = HibernateInstancesQueryCompiler.getDBField(string);
        return new LEEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object object2) {
                return Restrictions.le((String)string2, (Object)object);
            }

            public String getIdentifier() {
                return string;
            }
        };
    }

    protected LessEvaluator<String, Criterion, Object> compileLess(final Less less) {
        if (less.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)less.getIdentifier();
            return new LessEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object object) {
                    org.hibernate.criterion.Conjunction conjunction = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conjunction.add((Criterion)Restrictions.lt((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conjunction.add((Criterion)Restrictions.lt((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conjunction.add((Criterion)Restrictions.lt((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)less.getValue().getValue()));
                    return conjunction;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        final String string = less.getIdentifier().getName();
        final Object object = less.getValue().getValue();
        if (INSTANCE_STATUS_FIELD.equals(string)) {
            throw new IllegalArgumentException("Field status is not supported.");
        }
        final String string2 = HibernateInstancesQueryCompiler.getDBField(string);
        return new LessEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object object2) {
                return Restrictions.lt((String)string2, (Object)object);
            }

            public String getIdentifier() {
                return string;
            }
        };
    }

    protected LikeEvaluator<String, Criterion, Object> compileLike(final Like like) {
        if (like.getIdentifier() instanceof Property) {
            this.propertyInQuery = true;
            final Property property = (Property)like.getIdentifier();
            return new LikeEvaluator<String, Criterion, Object>(){

                public Criterion evaluate(Object object) {
                    org.hibernate.criterion.Conjunction conjunction = Restrictions.conjunction();
                    if (!StringUtils.isEmpty((String)property.getNamespace())) {
                        conjunction.add((Criterion)Restrictions.like((String)"process.typeNamespace", (Object)property.getNamespace()));
                    }
                    conjunction.add((Criterion)Restrictions.like((String)HibernateInstancesQueryCompiler.PROPERTY_NAME_DB_FIELD, (Object)property.getName()));
                    conjunction.add((Criterion)Restrictions.like((String)HibernateInstancesQueryCompiler.PROPERTY_VALUE_DB_FIELD, (Object)like.getValue().getValue()));
                    return conjunction;
                }

                public String getIdentifier() {
                    return property.toString();
                }
            };
        }
        String string = like.getIdentifier().getName();
        if (INSTANCE_STATUS_FIELD.equals(string)) {
            throw new IllegalArgumentException("Field status is not supported by like operation.");
        }
        if (INSTANCE_ID_FIELD.equals(string)) {
            throw new IllegalArgumentException("Field iid is not supported by like operation.");
        }
        final Object object = like.getValue().getValue();
        final String string2 = HibernateInstancesQueryCompiler.getDBField(string);
        return new LikeEvaluator<String, Criterion, Object>(){

            public Criterion evaluate(Object object2) {
                return Restrictions.like((String)string2, (Object)object);
            }

            public String getIdentifier() {
                return string2;
            }
        };
    }

    protected OrderByEvaluator<Collection<Order>, Object> compileOrderBy(OrderBy orderBy) {
        final LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        for (OrderByElement orderByElement : orderBy.getOrders()) {
            if (!(orderByElement.getIdentifier() instanceof Field)) {
                throw new IllegalArgumentException("Only field identifier supported by order by operator.");
            }
            String string = orderByElement.getIdentifier().getName();
            if (INSTANCE_STATUS_FIELD.equals(string)) {
                if (orderBy.getOrders().size() > 1) {
                    throw new RuntimeException("Status field should be used alone in <order by> construction.");
                }
                this.orderByStatus = true;
                this.orderByStatusDesc = orderByElement.getType() == OrderByType.DESC;
                return null;
            }
            String string2 = HibernateInstancesQueryCompiler.getDBField(string);
            linkedHashMap.put(string2, orderByElement.getType() == null || orderByElement.getType() == OrderByType.ASC);
        }
        return new OrderByEvaluator<Collection<Order>, Object>(){

            public Collection<Order> evaluate(Object object) {
                ArrayList<Order> arrayList = new ArrayList<Order>(linkedHashMap.size());
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    arrayList.add((Boolean)entry.getValue() != false ? Order.asc((String)((String)entry.getKey())) : Order.desc((String)((String)entry.getKey())));
                }
                return arrayList;
            }
        };
    }

    protected List<CommandEvaluator> evaluate(LogicExprNode logicExprNode) {
        ArrayList<CommandEvaluator> arrayList = new ArrayList<CommandEvaluator>(logicExprNode.getChilds().size());
        for (LogicNode logicNode : logicExprNode.getChilds()) {
            arrayList.add(this.compileEvaluator(logicNode));
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String string = "order by last-active desc limit 1000";
        Builder builder = BuilderFactory.getInstance().createBuilder();
        Node node = builder.build((Object)string);
        HibernateInstancesQueryCompiler hibernateInstancesQueryCompiler = new HibernateInstancesQueryCompiler();
        hibernateInstancesQueryCompiler.compile((Query)node);
    }

    static {
        nodeIdentifierToDBField.put(INSTANCE_ID_FIELD, INSTANCE_ID_DB_FIELD);
        nodeIdentifierToDBField.put(INSTANCE_ID_FIELD, INSTANCE_ID_DB_FIELD);
        nodeIdentifierToDBField.put(PROCESS_ID_FIELD, PROCESS_ID_DB_FIELD);
        nodeIdentifierToDBField.put(PROCESS_NAME_FIELD, PROCESS_NAME_DB_FIELD);
        nodeIdentifierToDBField.put(PROCESS_NAMESPACE_FIELD, "process.typeNamespace");
        nodeIdentifierToDBField.put(INSTANCE_STARTED_FIELD, INSTANCE_STARTED_DB_FIELD);
        nodeIdentifierToDBField.put(INSTANCE_LAST_ACTIVE_FIELD, INSTANCE_LAST_ACTIVE_DB_FIELD);
        nodeIdentifierToDBField.put(INSTANCE_STATUS_FIELD, INSTANCE_STATUS_DB_FIELD);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class FieldValueEquality
    extends AbstractEqualityEvaluator<String, Criterion, Object> {
        public FieldValueEquality(String string) {
            super((Object)string);
        }
    }

    private static class DBFieldValueEq
    extends FieldValueEquality {
        protected final Object fieldValue;

        public DBFieldValueEq(String string, Object object) {
            super(string);
            this.fieldValue = object;
        }

        public Criterion evaluate(Object object) {
            return Restrictions.eq((String)((String)this.identifier), (Object)this.fieldValue);
        }
    }
}

