/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.FaultDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.ScopeStateEnum;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.ActivityRecoveryDaoImpl;
import org.apache.ode.daohib.bpel.BpelDAOConnectionImpl;
import org.apache.ode.daohib.bpel.CorrelationSetDaoImpl;
import org.apache.ode.daohib.bpel.CorrelatorDaoImpl;
import org.apache.ode.daohib.bpel.FaultDAOImpl;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ScopeDaoImpl;
import org.apache.ode.daohib.bpel.XmlDataDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HActivityRecovery;
import org.apache.ode.daohib.bpel.hobj.HBpelEvent;
import org.apache.ode.daohib.bpel.hobj.HCorrelationSet;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HFaultData;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.daohib.bpel.hobj.HScope;
import org.apache.ode.daohib.bpel.hobj.HXmlData;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.QNameUtils;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.UnaryFunction;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessInstanceDaoImpl
extends HibernateDao
implements ProcessInstanceDAO {
    private static final String QRY_DELSELECTORS = "delete from " + HCorrelatorSelector.class.getName() + " where instance = ?";
    private static final String QRY_VARIABLES = "from " + HXmlData.class.getName() + " as x where x.name = ? and x.scope.scopeModelId = ? and x.scope.instance.id = ?";
    private static final String QRY_RECOVERIES = "from " + HActivityRecovery.class.getName() + " AS x WHERE x.instance.id = ?";
    private HProcessInstance _instance;
    private ScopeDAO _root;

    public ProcessInstanceDaoImpl(SessionManager sessionManager, HProcessInstance hProcessInstance) {
        super(sessionManager, hProcessInstance);
        this._instance = hProcessInstance;
    }

    public Date getCreateTime() {
        return this._instance.getCreated();
    }

    public void setFault(FaultDAO faultDAO) {
        this._instance.setFault(((FaultDAOImpl)faultDAO)._self);
        this.getSession().update((Object)this._instance);
    }

    public void setFault(QName qName, String string, int n, int n2, Element element) {
        if (this._instance.getFault() != null) {
            this.getSession().delete((Object)this._instance.getFault());
        }
        HFaultData hFaultData = new HFaultData();
        hFaultData.setName(QNameUtils.fromQName((QName)qName));
        hFaultData.setExplanation(string);
        hFaultData.setLineNo(n);
        hFaultData.setActivityId(n2);
        if (element != null) {
            HLargeData hLargeData = new HLargeData(DOMUtils.domToString((Node)element));
            hFaultData.setData(hLargeData);
            this.getSession().save((Object)hLargeData);
        }
        this._instance.setFault(hFaultData);
        this.getSession().save((Object)hFaultData);
        this.getSession().update((Object)this._instance);
    }

    public FaultDAO getFault() {
        if (this._instance.getFault() == null) {
            return null;
        }
        return new FaultDAOImpl(this._sm, this._instance.getFault());
    }

    public byte[] getExecutionState() {
        if (this._instance.getJacobState() == null) {
            return null;
        }
        return this._instance.getJacobState().getBinary();
    }

    public void setExecutionState(byte[] byArray) {
        if (this._instance.getJacobState() != null) {
            this.getSession().delete((Object)this._instance.getJacobState());
        }
        if (byArray.length > 0) {
            HLargeData hLargeData = new HLargeData(byArray);
            this._instance.setJacobState(hLargeData);
            this.getSession().save((Object)hLargeData);
        }
        this.getSession().update((Object)this._instance);
    }

    public ProcessDAO getProcess() {
        return new ProcessDaoImpl(this._sm, this._instance.getProcess());
    }

    public ScopeDAO getRootScope() {
        if (this._root != null) {
            return this._root;
        }
        Query query = this.getSession().createFilter(this._instance.getScopes(), "where this.parentScope is null");
        HScope hScope = (HScope)query.uniqueResult();
        if (hScope == null) {
            return null;
        }
        this._root = new ScopeDaoImpl(this._sm, hScope);
        return this._root;
    }

    public void setState(short s) {
        this._instance.setPreviousState(this._instance.getState());
        this._instance.setState(s);
        if (s == 60) {
            this.clearSelectors();
        }
        this.getSession().update((Object)this._instance);
    }

    public short getState() {
        return this._instance.getState();
    }

    public short getPreviousState() {
        return this._instance.getPreviousState();
    }

    public ScopeDAO createScope(ScopeDAO scopeDAO, String string, int n) {
        HScope hScope = new HScope();
        hScope.setParentScope(scopeDAO != null ? (HScope)((ScopeDaoImpl)scopeDAO).getHibernateObj() : null);
        hScope.setName(string);
        hScope.setScopeModelId(n);
        hScope.setState(ScopeStateEnum.ACTIVE.toString());
        hScope.setInstance(this._instance);
        hScope.setCreated(new Date());
        this.getSession().save((Object)hScope);
        return new ScopeDaoImpl(this._sm, hScope);
    }

    public Long getInstanceId() {
        return this._instance.getId();
    }

    public ScopeDAO getScope(Long l) {
        Long l2 = (long)l;
        HScope hScope = (HScope)this.getSession().get(HScope.class, (Serializable)l2);
        return hScope != null ? new ScopeDaoImpl(this._sm, hScope) : null;
    }

    public Collection<ScopeDAO> getScopes(String string) {
        List list;
        Query query;
        if (string != null) {
            query = this._sm.getSession().createFilter(this._instance.getScopes(), "where this.name=?");
            query.setString(0, string);
            list = query.list();
        } else {
            list = this._instance.getScopes();
        }
        query = new ArrayList();
        CollectionsX.transform((Collection)query, list, (UnaryFunction)new UnaryFunction<HScope, ScopeDAO>(){

            public ScopeDAO apply(HScope hScope) {
                return new ScopeDaoImpl(ProcessInstanceDaoImpl.this._sm, hScope);
            }
        });
        return query;
    }

    public Collection<ScopeDAO> getScopes() {
        return this.getScopes(null);
    }

    public CorrelatorDAO getInstantiatingCorrelator() {
        return new CorrelatorDaoImpl(this._sm, this._instance.getInstantiatingCorrelator());
    }

    public Date getLastActiveTime() {
        return this._instance.getLastActiveTime();
    }

    public void setLastActiveTime(Date date) {
        this._instance.setLastActiveTime(date);
    }

    public Set<CorrelationSetDAO> getCorrelationSets() {
        HashSet<CorrelationSetDAO> hashSet = new HashSet<CorrelationSetDAO>();
        for (HCorrelationSet hCorrelationSet : this._instance.getCorrelationSets()) {
            hashSet.add(new CorrelationSetDaoImpl(this._sm, hCorrelationSet));
        }
        return hashSet;
    }

    public CorrelationSetDAO getCorrelationSet(String string) {
        for (HCorrelationSet hCorrelationSet : this._instance.getCorrelationSets()) {
            if (!hCorrelationSet.getName().equals(string)) continue;
            return new CorrelationSetDaoImpl(this._sm, hCorrelationSet);
        }
        return null;
    }

    public XmlDataDAO[] getVariables(String string, int n) {
        ArrayList<XmlDataDaoImpl> arrayList = new ArrayList<XmlDataDaoImpl>();
        Query query = this.getSession().createQuery(QRY_VARIABLES);
        query.setString(0, string);
        query.setInteger(1, n);
        query.setLong(2, this._instance.getId().longValue());
        Iterator iterator = query.iterate();
        while (iterator.hasNext()) {
            arrayList.add(new XmlDataDaoImpl(this._sm, (HXmlData)iterator.next()));
        }
        Hibernate.close((Iterator)iterator);
        return arrayList.toArray(new XmlDataDAO[arrayList.size()]);
    }

    public void finishCompletion() {
        assert (ProcessState.isFinished((short)this.getState()));
        this.getProcess().instanceCompleted((ProcessInstanceDAO)this);
    }

    public void delete() {
        this._sm.getSession().delete((Object)this._instance);
    }

    public void insertBpelEvent(ProcessInstanceEvent processInstanceEvent) {
        BpelDAOConnectionImpl._insertBpelEvent(this._sm.getSession(), (BpelEvent)processInstanceEvent, this.getProcess(), this);
    }

    public ProcessInstanceDAO.EventsFirstLastCountTuple getEventsFirstLastCount() {
        Criteria criteria = this._sm.getSession().createCriteria(HBpelEvent.class);
        criteria.add((Criterion)Restrictions.eq((String)"instance", (Object)this._instance));
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.min((String)"tstamp")).add((Projection)Projections.max((String)"tstamp")).add((Projection)Projections.count((String)"tstamp")));
        Object[] objectArray = (Object[])criteria.uniqueResult();
        ProcessInstanceDAO.EventsFirstLastCountTuple eventsFirstLastCountTuple = new ProcessInstanceDAO.EventsFirstLastCountTuple();
        eventsFirstLastCountTuple.first = (Date)objectArray[0];
        eventsFirstLastCountTuple.last = (Date)objectArray[1];
        eventsFirstLastCountTuple.count = (Integer)objectArray[2];
        return eventsFirstLastCountTuple;
    }

    public long genMonotonic() {
        long l = this._instance.getSequence() + 1L;
        this._instance.setSequence(l);
        return l;
    }

    protected void clearSelectors() {
        Query query = this.getSession().createQuery(QRY_DELSELECTORS);
        query.setEntity(0, (Object)this._instance);
        query.executeUpdate();
    }

    public int getActivityFailureCount() {
        return this._instance.getActivityFailureCount();
    }

    public Date getActivityFailureDateTime() {
        return this._instance.getActivityFailureDateTime();
    }

    public Collection<ActivityRecoveryDAO> getActivityRecoveries() {
        ArrayList<ActivityRecoveryDAO> arrayList = new ArrayList<ActivityRecoveryDAO>();
        Query query = this.getSession().createQuery(QRY_RECOVERIES);
        query.setLong(0, this._instance.getId().longValue());
        Iterator iterator = query.iterate();
        while (iterator.hasNext()) {
            arrayList.add(new ActivityRecoveryDaoImpl(this._sm, (HActivityRecovery)iterator.next()));
        }
        Hibernate.close((Iterator)iterator);
        return arrayList;
    }

    public void createActivityRecovery(String string, long l, String string2, Date date, Element element, String[] stringArray, int n) {
        Object object;
        HActivityRecovery hActivityRecovery = new HActivityRecovery();
        hActivityRecovery.setInstance(this._instance);
        hActivityRecovery.setChannel(string);
        hActivityRecovery.setActivityId(l);
        hActivityRecovery.setReason(string2);
        hActivityRecovery.setDateTime(date);
        hActivityRecovery.setRetries(n);
        if (element != null) {
            object = new HLargeData(DOMUtils.domToString((Node)element));
            hActivityRecovery.setDetails((HLargeData)object);
            this.getSession().save(object);
        }
        object = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            object = (String)object + " " + stringArray[i];
        }
        hActivityRecovery.setActions((String)object);
        this.getSession().save((Object)hActivityRecovery);
        this._instance.setActivityFailureDateTime(date);
        this._instance.setActivityFailureCount(this._instance.getActivityFailureCount() + 1);
        this.getSession().update((Object)this._instance);
    }

    public void deleteActivityRecovery(String string) {
        for (HActivityRecovery hActivityRecovery : this._instance.getActivityRecoveries()) {
            if (!hActivityRecovery.getChannel().equals(string)) continue;
            this.getSession().delete((Object)hActivityRecovery);
            this._instance.setActivityFailureCount(this._instance.getActivityFailureCount() - 1);
            this.getSession().update((Object)this._instance);
            return;
        }
    }

    public BpelDAOConnection getConnection() {
        return new BpelDAOConnectionImpl(this._sm);
    }
}

