/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.MessageRouteDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.MessageExchangeDaoImpl;
import org.apache.ode.daohib.bpel.MessageRouteDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HCorrelator;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorMessage;
import org.apache.ode.daohib.bpel.hobj.HCorrelatorSelector;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.utils.CollectionUtils;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.Query;

class CorrelatorDaoImpl
extends HibernateDao
implements CorrelatorDAO {
    private static final String QRY_MESSAGE = " where this.correlationKey = ?".intern();
    private static final String FLTR_SELECTORS = ("from " + HCorrelatorSelector.class.getName() + " hs where hs.correlationKey = ? and hs.processType = ? and hs.correlator.correlatorId = ?").intern();
    private static final String LOCK_SELECTORS = "update from " + HCorrelatorSelector.class.getName() + " set lock = lock+1 where correlationKey = ? and processType = ?".intern();
    private static final String QRY_DELSELECTORS = "delete from " + HCorrelatorSelector.class.getName() + " where groupId = ? and instance = ?".intern();
    private static final String QRY_DELMESSAGES = "delete from " + HCorrelatorMessage.class.getName() + " where messageExchange = ?".intern();
    static Log __log = LogFactory.getLog(CorrelatorDaoImpl.class);
    private HCorrelator _hobj;

    public CorrelatorDaoImpl(SessionManager sessionManager, HCorrelator hCorrelator) {
        super(sessionManager, hCorrelator);
        this._hobj = hCorrelator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageExchangeDAO dequeueMessage(CorrelationKey correlationKey) {
        String string = "dequeueMessage(" + correlationKey + "): ";
        __log.debug((Object)string);
        Query query = this.getSession().createFilter(this._hobj.getMessageCorrelations(), QRY_MESSAGE);
        query.setString(0, correlationKey.toCanonicalString());
        Iterator iterator = query.iterate();
        try {
            if (!iterator.hasNext()) {
                __log.debug((Object)(string + "did not find a MESSAGE entry."));
                MessageExchangeDAO messageExchangeDAO = null;
                return messageExchangeDAO;
            }
            HCorrelatorMessage hCorrelatorMessage = (HCorrelatorMessage)iterator.next();
            __log.debug((Object)(string + "found MESSAGE entry " + hCorrelatorMessage.getMessageExchange()));
            this.removeEntries(hCorrelatorMessage.getMessageExchange());
            MessageExchangeDaoImpl messageExchangeDaoImpl = new MessageExchangeDaoImpl(this._sm, hCorrelatorMessage.getMessageExchange());
            return messageExchangeDaoImpl;
        }
        finally {
            Hibernate.close((Iterator)iterator);
        }
    }

    public MessageRouteDAO findRoute(CorrelationKey correlationKey) {
        String string = "findRoute(key=" + correlationKey + "): ";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)string);
        }
        String string2 = new QName(this._hobj.getProcess().getTypeNamespace(), this._hobj.getProcess().getTypeName()).toString();
        Query query = this.getSession().createQuery(LOCK_SELECTORS);
        query.setString(0, correlationKey == null ? null : correlationKey.toCanonicalString());
        query.setString(1, string2);
        if (query.executeUpdate() > 0) {
            HCorrelatorSelector hCorrelatorSelector;
            Query query2 = this.getSession().createQuery(FLTR_SELECTORS);
            query2.setString(0, correlationKey == null ? null : correlationKey.toCanonicalString());
            query2.setString(1, string2);
            query2.setString(2, this._hobj.getCorrelatorId());
            query2.setLockMode("hs", LockMode.UPGRADE);
            try {
                hCorrelatorSelector = (HCorrelatorSelector)query2.uniqueResult();
            }
            catch (Exception exception) {
                __log.debug((Object)"Strange, could not get a unique result for findRoute, trying to iterate instead.");
                Iterator iterator = query2.iterate();
                hCorrelatorSelector = iterator.hasNext() ? (HCorrelatorSelector)iterator.next() : null;
                Hibernate.close((Iterator)iterator);
            }
            __log.debug((Object)(string + "found " + hCorrelatorSelector));
            return hCorrelatorSelector == null ? null : new MessageRouteDaoImpl(this._sm, hCorrelatorSelector);
        }
        return null;
    }

    public void enqueueMessage(MessageExchangeDAO messageExchangeDAO, CorrelationKey[] correlationKeyArray) {
        Object[] objectArray = this.canonifyKeys(correlationKeyArray);
        String string = "enqueueMessage(mex=" + ((MessageExchangeDaoImpl)messageExchangeDAO)._hobj.getId() + " keys=" + CollectionUtils.makeCollection(ArrayList.class, (Object[])objectArray) + "): ";
        if (__log.isDebugEnabled()) {
            __log.debug((Object)string);
        }
        for (Object object : objectArray) {
            HCorrelatorMessage hCorrelatorMessage = new HCorrelatorMessage();
            hCorrelatorMessage.setCorrelator(this._hobj);
            hCorrelatorMessage.setCreated(new Date());
            hCorrelatorMessage.setCorrelationKey((String)object);
            hCorrelatorMessage.setMessageExchange((HMessageExchange)((MessageExchangeDaoImpl)messageExchangeDAO)._hobj);
            this.getSession().save((Object)hCorrelatorMessage);
            if (!__log.isDebugEnabled()) continue;
            __log.debug((Object)(string + "saved " + hCorrelatorMessage));
        }
    }

    private String[] canonifyKeys(CorrelationKey[] correlationKeyArray) {
        String[] stringArray = new String[correlationKeyArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = correlationKeyArray[i].toCanonicalString();
        }
        return stringArray;
    }

    public void addRoute(String string, ProcessInstanceDAO processInstanceDAO, int n, CorrelationKey correlationKey) {
        String string2 = "addRoute(" + string + ", iid=" + processInstanceDAO.getInstanceId() + ", idx=" + n + ", ckey=" + correlationKey + "): ";
        __log.debug((Object)string2);
        HCorrelatorSelector hCorrelatorSelector = new HCorrelatorSelector();
        hCorrelatorSelector.setGroupId(string);
        hCorrelatorSelector.setIndex(n);
        hCorrelatorSelector.setLock(0);
        hCorrelatorSelector.setCorrelationKey(correlationKey.toCanonicalString());
        hCorrelatorSelector.setInstance((HProcessInstance)((ProcessInstanceDaoImpl)processInstanceDAO).getHibernateObj());
        hCorrelatorSelector.setProcessType(processInstanceDAO.getProcess().getType().toString());
        hCorrelatorSelector.setCorrelator(this._hobj);
        hCorrelatorSelector.setCreated(new Date());
        this.getSession().save((Object)hCorrelatorSelector);
        __log.debug((Object)(string2 + "saved " + hCorrelatorSelector));
    }

    public boolean checkRoute(CorrelationKey correlationKey) {
        Query query = this.getSession().createQuery(LOCK_SELECTORS);
        query.setString("ckey", correlationKey == null ? null : correlationKey.toCanonicalString());
        query.setEntity("corr", (Object)this._hobj);
        query.setReadOnly(true);
        return query.list().isEmpty();
    }

    public String getCorrelatorId() {
        return this._hobj.getCorrelatorId();
    }

    public void removeRoutes(String string, ProcessInstanceDAO processInstanceDAO) {
        String string2 = "removeRoutes(" + string + ", iid=" + processInstanceDAO.getInstanceId() + "): ";
        __log.debug((Object)string2);
        Query query = this.getSession().createQuery(QRY_DELSELECTORS);
        query.setString(0, string);
        query.setEntity(1, (Object)((ProcessInstanceDaoImpl)processInstanceDAO).getHibernateObj());
        int n = query.executeUpdate();
        __log.debug((Object)(string2 + "deleted " + n + " rows"));
    }

    public void removeEntries(HMessageExchange hMessageExchange) {
        String string = "removeEntries(" + hMessageExchange + "): ";
        __log.debug((Object)string);
        Query query = this.getSession().createQuery(QRY_DELMESSAGES);
        query.setEntity(0, (Object)hMessageExchange);
        int n = query.executeUpdate();
        __log.debug((Object)(string + " deleted " + n + " rows"));
    }
}

