/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.daohib.SessionManager;
import org.apache.ode.daohib.bpel.HibernateDao;
import org.apache.ode.daohib.bpel.MessageDaoImpl;
import org.apache.ode.daohib.bpel.PartnerLinkDAOImpl;
import org.apache.ode.daohib.bpel.ProcessDaoImpl;
import org.apache.ode.daohib.bpel.ProcessInstanceDaoImpl;
import org.apache.ode.daohib.bpel.hobj.HLargeData;
import org.apache.ode.daohib.bpel.hobj.HMessage;
import org.apache.ode.daohib.bpel.hobj.HMessageExchange;
import org.apache.ode.daohib.bpel.hobj.HProcess;
import org.apache.ode.daohib.bpel.hobj.HProcessInstance;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageExchangeDaoImpl
extends HibernateDao
implements MessageExchangeDAO {
    private HMessageExchange _hself;
    private ProcessDAO _externalProcess;
    private ProcessInstanceDAO _externalInstance;

    public MessageExchangeDaoImpl(SessionManager sessionManager, HMessageExchange hMessageExchange) {
        super(sessionManager, hMessageExchange);
        this._hself = hMessageExchange;
    }

    public String getMessageExchangeId() {
        return this._hself.getId().toString();
    }

    public MessageDAO getResponse() {
        return this._hself.getResponse() == null ? null : new MessageDaoImpl(this._sm, this._hself.getResponse());
    }

    public Date getCreateTime() {
        return this._hself.getInsertTime();
    }

    public MessageDAO getRequest() {
        return this._hself.getRequest() == null ? null : new MessageDaoImpl(this._sm, this._hself.getRequest());
    }

    public String getOperation() {
        return this._hself.getOperationName();
    }

    public QName getPortType() {
        return this._hself.getPortType() == null ? null : QName.valueOf(this._hself.getPortType());
    }

    public void setPortType(QName qName) {
        this._hself.setPortType(qName == null ? null : qName.toString());
        this.update();
    }

    public void setStatus(String string) {
        this._hself.setState(string);
        this.update();
    }

    public String getStatus() {
        return this._hself.getState();
    }

    public MessageDAO createMessage(QName qName) {
        HMessage hMessage = new HMessage();
        hMessage.setType(qName == null ? null : qName.toString());
        hMessage.setCreated(new Date());
        hMessage.setMessageExchange(this._hself);
        this.getSession().save((Object)hMessage);
        return new MessageDaoImpl(this._sm, hMessage);
    }

    public void setRequest(MessageDAO messageDAO) {
        this._hself.setRequest(messageDAO == null ? null : (HMessage)((MessageDaoImpl)messageDAO).getHibernateObj());
        this.update();
    }

    public void setResponse(MessageDAO messageDAO) {
        this._hself.setResponse(messageDAO == null ? null : (HMessage)((MessageDaoImpl)messageDAO).getHibernateObj());
        this.update();
    }

    public int getPartnerLinkModelId() {
        return this._hself.getPartnerLinkModelId();
    }

    public void setPartnerLinkModelId(int n) {
        this._hself.setPartnerLinkModelId(n);
        this.update();
    }

    public String getCorrelationId() {
        return this._hself.getClientKey();
    }

    public void setCorrelationId(String string) {
        this._hself.setClientKey(string);
        this.update();
    }

    public void setPattern(String string) {
        this._hself.setPattern(string);
        this.update();
    }

    public void setOperation(String string) {
        this._hself.setOperationName(string);
        this.update();
    }

    public void setEPR(Element element) {
        if (element == null) {
            this._hself.setEndpoint(null);
        } else {
            HLargeData hLargeData = new HLargeData(DOMUtils.domToString((Node)element));
            this.getSession().save((Object)hLargeData);
            this._hself.setEndpoint(hLargeData);
        }
        this.getSession().saveOrUpdate((Object)this._hself);
    }

    public Element getEPR() {
        HLargeData hLargeData = this._hself.getEndpoint();
        if (hLargeData == null) {
            return null;
        }
        try {
            return DOMUtils.stringToDOM((String)hLargeData.getText());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setCallbackEPR(Element element) {
        if (element == null) {
            this._hself.setCallbackEndpoint(null);
        } else {
            HLargeData hLargeData = new HLargeData(DOMUtils.domToString((Node)element));
            this.getSession().save((Object)hLargeData);
            this._hself.setCallbackEndpoint(hLargeData);
        }
        this.getSession().saveOrUpdate((Object)this._hself);
    }

    public Element getCallbackEPR() {
        HLargeData hLargeData = this._hself.getCallbackEndpoint();
        if (hLargeData == null) {
            return null;
        }
        try {
            return DOMUtils.stringToDOM((String)hLargeData.getText());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getPattern() {
        return this._hself.getPattern();
    }

    public String getChannel() {
        return this._hself.getChannelName();
    }

    public void setChannel(String string) {
        this._hself.setChannelName(string);
        this.update();
    }

    public boolean getPropagateTransactionFlag() {
        return false;
    }

    public QName getFault() {
        return this._hself.getFault() == null ? null : QName.valueOf(this._hself.getFault());
    }

    public void setFault(QName qName) {
        this._hself.setFault(qName == null ? null : qName.toString());
        this.update();
    }

    public String getFaultExplanation() {
        return this._hself.getFaultExplanation();
    }

    public void setFaultExplanation(String string) {
        this._hself.setFaultExplanation(string);
        this.update();
    }

    public void setCorrelationStatus(String string) {
        this._hself.setCorrelationStatus(string);
        this.update();
    }

    public String getCorrelationStatus() {
        return this._hself.getCorrelationStatus();
    }

    public ProcessDAO getProcess() {
        if (this._externalProcess != null) {
            return this._externalProcess;
        }
        return this._hself.getProcess() == null ? null : new ProcessDaoImpl(this._sm, this._hself.getProcess());
    }

    public void setProcess(ProcessDAO processDAO) {
        if (processDAO == null || processDAO instanceof ProcessDaoImpl) {
            this._hself.setProcess(processDAO == null ? null : (HProcess)((ProcessDaoImpl)processDAO).getHibernateObj());
            this.update();
        } else {
            this._externalProcess = processDAO;
        }
    }

    public void setInstance(ProcessInstanceDAO processInstanceDAO) {
        if (processInstanceDAO == null || processInstanceDAO instanceof ProcessInstanceDaoImpl) {
            this._hself.setInstance(processInstanceDAO == null ? null : (HProcessInstance)((ProcessInstanceDaoImpl)processInstanceDAO).getHibernateObj());
            this.update();
        } else {
            this._externalInstance = processInstanceDAO;
        }
    }

    public ProcessInstanceDAO getInstance() {
        if (this._externalInstance != null) {
            return this._externalInstance;
        }
        return this._hself.getInstance() == null ? null : new ProcessInstanceDaoImpl(this._sm, this._hself.getInstance());
    }

    public char getDirection() {
        return this._hself.getDirection();
    }

    public QName getCallee() {
        String string = this._hself.getCallee();
        return string == null ? null : QName.valueOf(string);
    }

    public void setCallee(QName qName) {
        this._hself.setCallee(qName == null ? null : qName.toString());
        this.update();
    }

    public String getProperty(String string) {
        return this._hself.getProperties().get(string);
    }

    public void setProperty(String string, String string2) {
        this._hself.getProperties().put(string, string2);
        this.update();
    }

    public void setPartnerLink(PartnerLinkDAO partnerLinkDAO) {
        this._hself.setPartnerLink(((PartnerLinkDAOImpl)partnerLinkDAO)._self);
        this.update();
    }

    public PartnerLinkDAO getPartnerLink() {
        return new PartnerLinkDAOImpl(this._sm, this._hself.getPartnerLink());
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this._hself.getProperties().keySet());
    }

    public String getPipedMessageExchangeId() {
        return this._hself.getPipedMessageExchangeId();
    }

    public void setPipedMessageExchangeId(String string) {
        this._hself.setPipedMessageExchangeId(string);
    }

    public void release() {
    }
}

