/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.daohib.bpel;

import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.utils.ISO8601DateParser;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

class CriteriaBuilder {
    CriteriaBuilder() {
    }

    void buildCriteria(Criteria criteria, InstanceFilter instanceFilter) {
        Object object;
        Criteria criteria2 = criteria.createCriteria("process");
        if (instanceFilter.getPidFilter() != null) {
            criteria2.add((Criterion)Restrictions.like((String)"processId", (Object)instanceFilter.getPidFilter().replaceAll("\\*", "%")));
        }
        if (instanceFilter.getIidFilter() != null) {
            criteria.add((Criterion)Restrictions.eq((String)"id", (Object)new Long(instanceFilter.getIidFilter())));
        }
        if (instanceFilter.getNameFilter() != null) {
            criteria2.add((Criterion)Restrictions.like((String)"typeName", (Object)instanceFilter.getNameFilter().replaceAll("\\*", "%")));
        }
        if (instanceFilter.getNamespaceFilter() != null) {
            criteria2.add((Criterion)Restrictions.like((String)"typeNamespace", (Object)instanceFilter.getNamespaceFilter().replaceAll("\\*", "%")));
        }
        if (instanceFilter.getStatusFilter() != null) {
            object = instanceFilter.convertFilterState();
            Object object2 = Restrictions.disjunction();
            Iterator object3 = object.iterator();
            while (object3.hasNext()) {
                short s = (Short)object3.next();
                object2.add((Criterion)Restrictions.eq((String)"state", (Object)s));
            }
            criteria.add((Criterion)object2);
        }
        if (instanceFilter.getStartedDateFilter() != null) {
            for (Object object2 : instanceFilter.getStartedDateFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(criteria, (String)object2, "created");
            }
        }
        if (instanceFilter.getLastActiveDateFilter() != null) {
            for (Object object2 : instanceFilter.getLastActiveDateFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(criteria, (String)object2, "lastActiveTime");
            }
        }
        if (instanceFilter.getPropertyValuesFilter() != null) {
            object = criteria.createCriteria("correlationSets").createCriteria("properties");
            for (Map.Entry entry : instanceFilter.getPropertyValuesFilter().entrySet()) {
                String string = (String)entry.getKey();
                if (string.startsWith("{")) {
                    String string2 = string.substring(1, string.lastIndexOf("}"));
                    string = string.substring(string.lastIndexOf("}") + 1, string.length());
                    object.add((Criterion)Restrictions.eq((String)"name", (Object)string)).add((Criterion)Restrictions.eq((String)"namespace", (Object)string2)).add((Criterion)Restrictions.eq((String)"value", entry.getValue()));
                    continue;
                }
                object.add((Criterion)Restrictions.eq((String)"name", entry.getKey())).add((Criterion)Restrictions.eq((String)"value", entry.getValue()));
            }
        }
        if (instanceFilter.orders != null) {
            for (Object object2 : instanceFilter.orders) {
                boolean bl;
                boolean bl2 = true;
                Object object3 = object2;
                if (((String)object2).startsWith("+") || ((String)object2).startsWith("-")) {
                    object3 = ((String)object2).substring(1, ((String)object2).length());
                    if (((String)object2).startsWith("-")) {
                        bl = false;
                    }
                }
                if ("name".equals(object3)) {
                    if (bl) {
                        criteria2.addOrder(Property.forName((String)"typeName").asc());
                        continue;
                    }
                    criteria2.addOrder(Property.forName((String)"typeName").desc());
                    continue;
                }
                if ("namespace".equals(object3)) {
                    if (bl) {
                        criteria2.addOrder(Property.forName((String)"typeNamespace").asc());
                        continue;
                    }
                    criteria2.addOrder(Property.forName((String)"typeNamespace").desc());
                    continue;
                }
                if ("pid".equals(object3)) {
                    if (bl) {
                        criteria2.addOrder(Property.forName((String)"processId").asc());
                        continue;
                    }
                    criteria2.addOrder(Property.forName((String)"processId").desc());
                    continue;
                }
                if ("version".equals(object3)) {
                    if (bl) {
                        criteria2.addOrder(Property.forName((String)"version").asc());
                        continue;
                    }
                    criteria2.addOrder(Property.forName((String)"version").desc());
                    continue;
                }
                if ("status".equals(object3)) {
                    if (bl) {
                        criteria.addOrder(Property.forName((String)"state").asc());
                        continue;
                    }
                    criteria.addOrder(Property.forName((String)"state").desc());
                    continue;
                }
                if ("started".equals(object3)) {
                    if (bl) {
                        criteria.addOrder(Property.forName((String)"created").asc());
                        continue;
                    }
                    criteria.addOrder(Property.forName((String)"created").desc());
                    continue;
                }
                if (!"last-active".equals(object3)) continue;
                if (bl) {
                    criteria.addOrder(Property.forName((String)"lastActiveTime").asc());
                    continue;
                }
                criteria.addOrder(Property.forName((String)"lastActiveTime").desc());
            }
        }
        if (instanceFilter.getLimit() > 0) {
            criteria.setMaxResults(instanceFilter.getLimit());
        }
    }

    void buildCriteria(Criteria criteria, BpelEventFilter bpelEventFilter) {
        if (bpelEventFilter.getTypeFilter() != null) {
            criteria.add((Criterion)Restrictions.like((String)"type", (Object)bpelEventFilter.getTypeFilter().replace('*', '%')));
        }
        if (bpelEventFilter.getTimestampFilter() != null) {
            for (Filter.Restriction restriction : bpelEventFilter.getTimestampFilter()) {
                CriteriaBuilder.addFilterOnPrefixedDate(criteria, restriction.op, (Date)restriction.value, "tstamp");
            }
        }
        if (bpelEventFilter.limit > 0) {
            criteria.setMaxResults(bpelEventFilter.limit);
        }
    }

    void addScopeFilter(Criteria criteria, String string) {
        criteria.add((Criterion)Restrictions.eq((String)"", (Object)string));
    }

    static void addFilterOnPrefixedDate(Criteria criteria, String string, String string2) {
        Date date = null;
        try {
            date = ISO8601DateParser.parse((String)CriteriaBuilder.getDateWithoutOp(string));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        CriteriaBuilder.addFilterOnPrefixedDate(criteria, string, date, string2);
    }

    static void addFilterOnPrefixedDate(Criteria criteria, String string, Date date, String string2) {
        if (string.startsWith("=")) {
            criteria.add((Criterion)Restrictions.eq((String)string2, (Object)date));
        } else if (string.startsWith("<=")) {
            criteria.add((Criterion)Restrictions.le((String)string2, (Object)date));
        } else if (string.startsWith(">=")) {
            criteria.add((Criterion)Restrictions.ge((String)string2, (Object)date));
        } else if (string.startsWith("<")) {
            criteria.add((Criterion)Restrictions.lt((String)string2, (Object)date));
        } else if (string.startsWith(">")) {
            criteria.add((Criterion)Restrictions.gt((String)string2, (Object)date));
        }
    }

    private static String getDateWithoutOp(String string) {
        return Filter.getDateWithoutOp((String)string);
    }
}

