/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.nimbusds.openid.connect.sdk.validators.AccessTokenValidator;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import com.nimbusds.openid.connect.sdk.validators.InvalidHashException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.exception.IdentityAccessException;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.security.util.StandardTlsConfiguration;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsException;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.oidc.OidcIdentityProvider;
import org.apache.nifi.web.security.oidc.TruststoreStrategy;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class StandardOidcIdentityProvider
implements OidcIdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardOidcIdentityProvider.class);
    private final String EMAIL_CLAIM = "email";
    private final NiFiProperties properties;
    private OIDCProviderMetadata oidcProviderMetadata;
    private int oidcConnectTimeout;
    private int oidcReadTimeout;
    private IDTokenValidator tokenValidator;
    private ClientID clientId;
    private Secret clientSecret;
    private SSLContext sslContext;

    public StandardOidcIdentityProvider(NiFiProperties properties) {
        this.properties = properties;
    }

    @Override
    public void initializeProvider() {
        if (!this.properties.isOidcEnabled()) {
            logger.debug("The OIDC provider is not configured or enabled");
            return;
        }
        if (TruststoreStrategy.NIFI.name().equals(this.properties.getOidcClientTruststoreStrategy())) {
            this.setSslContext();
        }
        this.validateOIDCConfiguration();
        try {
            this.oidcProviderMetadata = this.retrieveOidcProviderMetadata(this.properties.getOidcDiscoveryUrl());
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | IOException e) {
            throw new RuntimeException("Unable to retrieve OpenId Connect Provider metadata from: " + this.properties.getOidcDiscoveryUrl(), e);
        }
        this.validateOIDCProviderMetadata();
    }

    private void setSslContext() {
        TlsConfiguration tlsConfiguration = StandardTlsConfiguration.fromNiFiProperties((NiFiProperties)this.properties);
        try {
            this.sslContext = SslContextFactory.createSslContext((TlsConfiguration)tlsConfiguration);
        }
        catch (TlsException e) {
            throw new RuntimeException("Unable to establish an SSL context for OIDC identity provider from nifi.properties", e);
        }
    }

    private void validateOIDCProviderMetadata() {
        if (this.oidcProviderMetadata.getAuthorizationEndpointURI() == null) {
            throw new RuntimeException("OpenId Connect Provider metadata does not contain an Authorization Endpoint.");
        }
        if (this.oidcProviderMetadata.getTokenEndpointURI() == null) {
            throw new RuntimeException("OpenId Connect Provider metadata does not contain a Token Endpoint.");
        }
        ArrayList<ClientAuthenticationMethod> clientAuthenticationMethods = this.oidcProviderMetadata.getTokenEndpointAuthMethods();
        logger.info("OpenId Connect: Available clientAuthenticationMethods {} ", (Object)clientAuthenticationMethods);
        if (clientAuthenticationMethods == null || clientAuthenticationMethods.isEmpty()) {
            clientAuthenticationMethods = new ArrayList<ClientAuthenticationMethod>();
            clientAuthenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
            this.oidcProviderMetadata.setTokenEndpointAuthMethods(clientAuthenticationMethods);
            logger.warn("OpenId Connect: ClientAuthenticationMethods is null, Setting clientAuthenticationMethods as CLIENT_SECRET_BASIC");
        } else if (!clientAuthenticationMethods.contains(ClientAuthenticationMethod.CLIENT_SECRET_BASIC) && !clientAuthenticationMethods.contains(ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
            throw new RuntimeException(String.format("OpenId Connect Provider does not support %s or %s", ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue(), ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue()));
        }
        List allowedAlgorithms = this.oidcProviderMetadata.getIDTokenJWSAlgs();
        if (allowedAlgorithms == null || allowedAlgorithms.isEmpty()) {
            throw new RuntimeException("The OpenId Connect Provider does not support any JWS algorithms.");
        }
        try {
            JWSAlgorithm preferredJwsAlgorithm = this.extractJwsAlgorithm();
            if (preferredJwsAlgorithm == null) {
                this.tokenValidator = new IDTokenValidator(this.oidcProviderMetadata.getIssuer(), this.clientId);
            } else if (JWSAlgorithm.HS256.equals((Object)preferredJwsAlgorithm) || JWSAlgorithm.HS384.equals((Object)preferredJwsAlgorithm) || JWSAlgorithm.HS512.equals((Object)preferredJwsAlgorithm)) {
                this.tokenValidator = new IDTokenValidator(this.oidcProviderMetadata.getIssuer(), this.clientId, preferredJwsAlgorithm, this.clientSecret);
            } else {
                ResourceRetriever retriever = this.getResourceRetriever();
                this.tokenValidator = new IDTokenValidator(this.oidcProviderMetadata.getIssuer(), this.clientId, preferredJwsAlgorithm, this.oidcProviderMetadata.getJWKSetURI().toURL(), retriever);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create the ID token validator for the configured OpenId Connect Provider: " + e.getMessage(), e);
        }
    }

    private JWSAlgorithm extractJwsAlgorithm() {
        String rawPreferredJwsAlgorithm = this.properties.getOidcPreferredJwsAlgorithm();
        Object preferredJwsAlgorithm = StringUtils.isBlank((CharSequence)rawPreferredJwsAlgorithm) ? JWSAlgorithm.RS256 : ("none".equalsIgnoreCase(rawPreferredJwsAlgorithm) ? null : JWSAlgorithm.parse((String)rawPreferredJwsAlgorithm));
        return preferredJwsAlgorithm;
    }

    private void validateOIDCConfiguration() {
        if (this.properties.isLoginIdentityProviderEnabled() || this.properties.isKnoxSsoEnabled()) {
            throw new RuntimeException("OpenId Connect support cannot be enabled if the Login Identity Provider or Apache Knox SSO is configured.");
        }
        String rawConnectTimeout = this.properties.getOidcConnectTimeout();
        try {
            this.oidcConnectTimeout = (int)FormatUtils.getPreciseTimeDuration((String)rawConnectTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("Failed to parse value of property '{}' as a valid time period. Value was '{}'. Ignoring this value and using the default value of '{}'", new Object[]{"nifi.security.user.oidc.connect.timeout", rawConnectTimeout, "5 secs"});
            this.oidcConnectTimeout = (int)FormatUtils.getPreciseTimeDuration((String)"5 secs", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        String rawReadTimeout = this.properties.getOidcReadTimeout();
        try {
            this.oidcReadTimeout = (int)FormatUtils.getPreciseTimeDuration((String)rawReadTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("Failed to parse value of property '{}' as a valid time period. Value was '{}'. Ignoring this value and using the default value of '{}'", new Object[]{"nifi.security.user.oidc.read.timeout", rawReadTimeout, "5 secs"});
            this.oidcReadTimeout = (int)FormatUtils.getPreciseTimeDuration((String)"5 secs", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        String rawClientId = this.properties.getOidcClientId();
        if (StringUtils.isBlank((CharSequence)rawClientId)) {
            throw new RuntimeException("Client ID is required when configuring an OIDC Provider.");
        }
        this.clientId = new ClientID(rawClientId);
        String rawClientSecret = this.properties.getOidcClientSecret();
        if (StringUtils.isBlank((CharSequence)rawClientSecret)) {
            throw new RuntimeException("Client secret is required when configuring an OIDC Provider.");
        }
        this.clientSecret = new Secret(rawClientSecret);
    }

    private OIDCProviderMetadata retrieveOidcProviderMetadata(String discoveryUri) throws IOException, com.nimbusds.oauth2.sdk.ParseException {
        URL url = new URL(discoveryUri);
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.GET, url);
        this.setHttpRequestProperties(httpRequest);
        HTTPResponse httpResponse = httpRequest.send();
        if (httpResponse.getStatusCode() != 200) {
            throw new IOException("Unable to download OpenId Connect Provider metadata from " + url + ": Status code " + httpResponse.getStatusCode());
        }
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return OIDCProviderMetadata.parse((JSONObject)jsonObject);
    }

    @Override
    public boolean isOidcEnabled() {
        return this.properties.isOidcEnabled();
    }

    @Override
    public URI getAuthorizationEndpoint() {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        return this.oidcProviderMetadata.getAuthorizationEndpointURI();
    }

    @Override
    public URI getEndSessionEndpoint() {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        return this.oidcProviderMetadata.getEndSessionEndpointURI();
    }

    @Override
    public URI getRevocationEndpoint() {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        return this.oidcProviderMetadata.getRevocationEndpointURI();
    }

    @Override
    public Scope getScope() {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        Scope scope = new Scope(new String[]{"openid", "email"});
        for (String additionalScope : this.properties.getOidcAdditionalScopes()) {
            scope.add(additionalScope);
        }
        return scope;
    }

    @Override
    public ClientID getClientId() {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        return this.clientId;
    }

    @Override
    public LoginAuthenticationToken exchangeAuthorizationCodeforLoginAuthenticationToken(AuthorizationGrant authorizationGrant) throws IOException {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        try {
            TokenResponse response = this.authorizeClient(authorizationGrant);
            return this.convertOIDCTokenToLoginAuthenticationToken((OIDCTokenResponse)response);
        }
        catch (JOSEException | BadJOSEException | com.nimbusds.oauth2.sdk.ParseException | RuntimeException | ParseException e) {
            throw new RuntimeException("Unable to parse the response from the Token request: " + e.getMessage(), e);
        }
    }

    @Override
    public String exchangeAuthorizationCodeForAccessToken(AuthorizationGrant authorizationGrant) throws Exception {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        try {
            TokenResponse response = this.authorizeClient(authorizationGrant);
            return this.getAccessTokenString((OIDCTokenResponse)response);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | InvalidHashException | IOException | RuntimeException | ParseException e) {
            throw new RuntimeException("Unable to parse the response from the Token request: " + e.getMessage(), e);
        }
    }

    @Override
    public String exchangeAuthorizationCodeForIdToken(AuthorizationGrant authorizationGrant) {
        if (!this.isOidcEnabled()) {
            throw new IllegalStateException("OpenId Connect support is not configured");
        }
        try {
            TokenResponse response = this.authorizeClient(authorizationGrant);
            return this.getIdTokenString((OIDCTokenResponse)response);
        }
        catch (JOSEException | BadJOSEException | com.nimbusds.oauth2.sdk.ParseException | IOException | RuntimeException e) {
            throw new RuntimeException("Unable to parse the response from the Token request: " + e.getMessage(), e);
        }
    }

    private String getAccessTokenString(OIDCTokenResponse response) throws Exception {
        OIDCTokens oidcTokens = this.getOidcTokens(response);
        this.validateAccessToken(oidcTokens);
        return oidcTokens.getAccessToken().getValue();
    }

    private String getIdTokenString(OIDCTokenResponse response) throws BadJOSEException, JOSEException {
        OIDCTokens oidcTokens = this.getOidcTokens(response);
        this.validateIdToken(oidcTokens.getIDToken());
        return oidcTokens.getIDTokenString();
    }

    private TokenResponse authorizeClient(AuthorizationGrant authorizationGrant) throws com.nimbusds.oauth2.sdk.ParseException, IOException {
        ClientAuthentication clientAuthentication = this.createClientAuthentication();
        HTTPRequest tokenHttpRequest = this.createTokenHTTPRequest(authorizationGrant, clientAuthentication);
        return this.authorizeClientRequest(tokenHttpRequest);
    }

    private TokenResponse authorizeClientRequest(HTTPRequest tokenHttpRequest) throws com.nimbusds.oauth2.sdk.ParseException, IOException {
        TokenResponse response = OIDCTokenResponseParser.parse((HTTPResponse)tokenHttpRequest.send());
        if (response.indicatesSuccess()) {
            return response;
        }
        TokenErrorResponse errorResponse = (TokenErrorResponse)response;
        ErrorObject errorObject = errorResponse.getErrorObject();
        throw new RuntimeException("An error occurred while invoking the Token endpoint: " + errorObject.getDescription() + " (" + errorObject.getCode() + ")");
    }

    private LoginAuthenticationToken convertOIDCTokenToLoginAuthenticationToken(OIDCTokenResponse response) throws BadJOSEException, JOSEException, ParseException, IOException {
        OIDCTokens oidcTokens = this.getOidcTokens(response);
        JWT oidcJwt = oidcTokens.getIDToken();
        IDTokenClaimsSet claimsSet = this.validateIdToken(oidcJwt);
        String identityClaim = this.properties.getOidcClaimIdentifyingUser();
        String identity = claimsSet.getStringClaim(identityClaim);
        String groupsClaim = this.properties.getOidcClaimGroups();
        List groups = claimsSet.getStringListClaim(groupsClaim);
        if (StringUtils.isBlank((CharSequence)identity)) {
            List<String> availableClaims = StandardOidcIdentityProvider.getAvailableClaims(oidcJwt.getJWTClaimsSet());
            logger.warn("Failed to obtain the identity of the user with the claim '{}'. The available claims on the OIDC response are: {}. Will attempt to obtain the identity from secondary sources", (Object)identityClaim, availableClaims);
            if (!identityClaim.equalsIgnoreCase("email") && availableClaims.contains("email")) {
                identity = claimsSet.getStringClaim("email");
                logger.info("The 'email' claim was present. Using that claim to avoid extra remote call");
            } else {
                List fallbackClaims = this.properties.getOidcFallbackClaimsIdentifyingUser();
                for (String fallbackClaim : fallbackClaims) {
                    if (!availableClaims.contains(fallbackClaim)) continue;
                    identity = claimsSet.getStringClaim(fallbackClaim);
                    break;
                }
                if (StringUtils.isBlank((CharSequence)identity)) {
                    identity = this.retrieveIdentityFromUserInfoEndpoint(oidcTokens);
                }
            }
        }
        Calendar now = Calendar.getInstance();
        Date expiration = claimsSet.getExpirationTime();
        long expiresIn = expiration.getTime() - now.getTimeInMillis();
        Set authorities = groups != null ? groups.stream().map(group -> new SimpleGrantedAuthority(group)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet)) : null;
        return new LoginAuthenticationToken(identity, identity, expiresIn, claimsSet.getIssuer().getValue(), authorities);
    }

    private OIDCTokens getOidcTokens(OIDCTokenResponse response) {
        return response.getOIDCTokens();
    }

    private String retrieveIdentityFromUserInfoEndpoint(OIDCTokens oidcTokens) throws IOException {
        BearerAccessToken bearerAccessToken = oidcTokens.getBearerAccessToken();
        if (bearerAccessToken == null) {
            throw new IllegalStateException("No access token found in the ID tokens");
        }
        HTTPRequest userInfoRequest = this.createUserInfoRequest(bearerAccessToken);
        return this.lookupIdentityInUserInfo(userInfoRequest);
    }

    private HTTPRequest createTokenHTTPRequest(AuthorizationGrant authorizationGrant, ClientAuthentication clientAuthentication) {
        TokenRequest request = new TokenRequest(this.oidcProviderMetadata.getTokenEndpointURI(), clientAuthentication, authorizationGrant);
        return this.formHTTPRequest((Request)request);
    }

    private HTTPRequest createUserInfoRequest(BearerAccessToken bearerAccessToken) {
        UserInfoRequest request = new UserInfoRequest(this.oidcProviderMetadata.getUserInfoEndpointURI(), (AccessToken)bearerAccessToken);
        return this.formHTTPRequest((Request)request);
    }

    private HTTPRequest formHTTPRequest(Request request) {
        return this.setHttpRequestProperties(request.toHTTPRequest());
    }

    private HTTPRequest setHttpRequestProperties(HTTPRequest httpRequest) {
        httpRequest.setConnectTimeout(this.oidcConnectTimeout);
        httpRequest.setReadTimeout(this.oidcReadTimeout);
        if (TruststoreStrategy.NIFI.name().equals(this.properties.getOidcClientTruststoreStrategy())) {
            httpRequest.setSSLSocketFactory(this.sslContext.getSocketFactory());
        }
        return httpRequest;
    }

    private ResourceRetriever getResourceRetriever() {
        if (TruststoreStrategy.NIFI.name().equals(this.properties.getOidcClientTruststoreStrategy())) {
            return new DefaultResourceRetriever(this.oidcConnectTimeout, this.oidcReadTimeout, 0, true, this.sslContext.getSocketFactory());
        }
        return new DefaultResourceRetriever(this.oidcConnectTimeout, this.oidcReadTimeout);
    }

    private ClientAuthentication createClientAuthentication() {
        List authMethods = this.oidcProviderMetadata.getTokenEndpointAuthMethods();
        Object clientAuthentication = authMethods != null && authMethods.contains(ClientAuthenticationMethod.CLIENT_SECRET_POST) ? new ClientSecretPost(this.clientId, this.clientSecret) : new ClientSecretBasic(this.clientId, this.clientSecret);
        return clientAuthentication;
    }

    private static List<String> getAvailableClaims(JWTClaimsSet claimSet) {
        return claimSet.getClaims().entrySet().stream().filter(e -> e.getValue() != null && StringUtils.isNotBlank((CharSequence)e.getValue().toString())).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    private void validateAccessToken(OIDCTokens oidcTokens) throws Exception {
        AccessToken accessToken = oidcTokens.getAccessToken();
        JWSAlgorithm jwsAlgorithm = this.extractJwsAlgorithm();
        String atHashString = oidcTokens.getIDToken().getJWTClaimsSet().getStringClaim("at_hash");
        AccessTokenHash atHash = new AccessTokenHash(atHashString);
        try {
            AccessTokenValidator.validate((AccessToken)accessToken, (JWSAlgorithm)jwsAlgorithm, (AccessTokenHash)atHash);
        }
        catch (InvalidHashException e) {
            throw new Exception("Unable to validate the Access Token: " + e.getMessage());
        }
    }

    private IDTokenClaimsSet validateIdToken(JWT oidcJwt) throws BadJOSEException, JOSEException {
        try {
            return this.tokenValidator.validate(oidcJwt, null);
        }
        catch (BadJOSEException e) {
            throw new BadJOSEException("Unable to validate the ID Token: " + e.getMessage());
        }
    }

    private String lookupIdentityInUserInfo(HTTPRequest userInfoHttpRequest) throws IOException {
        try {
            UserInfoResponse response = UserInfoResponse.parse((HTTPResponse)userInfoHttpRequest.send());
            if (response.indicatesSuccess()) {
                UserInfoSuccessResponse successResponse = (UserInfoSuccessResponse)response;
                JWTClaimsSet claimsSet = successResponse.getUserInfo() != null ? successResponse.getUserInfo().toJWTClaimsSet() : successResponse.getUserInfoJWT().getJWTClaimsSet();
                String identity = claimsSet.getStringClaim(this.properties.getOidcClaimIdentifyingUser());
                if (StringUtils.isBlank((CharSequence)identity)) {
                    throw new IllegalStateException("Unable to extract identity from the UserInfo token using the claim '" + this.properties.getOidcClaimIdentifyingUser() + "'.");
                }
                return identity;
            }
            UserInfoErrorResponse errorResponse = (UserInfoErrorResponse)response;
            throw new IdentityAccessException("An error occurred while invoking the UserInfo endpoint: " + errorResponse.getErrorObject().getDescription());
        }
        catch (com.nimbusds.oauth2.sdk.ParseException | ParseException e) {
            throw new IdentityAccessException("Unable to parse the response from the UserInfo token request: " + e.getMessage());
        }
    }
}

