/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.knox;

import com.nimbusds.jose.JOSEException;
import java.text.ParseException;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.InvalidAuthenticationException;
import org.apache.nifi.web.security.NiFiAuthenticationProvider;
import org.apache.nifi.web.security.knox.KnoxAuthenticationRequestToken;
import org.apache.nifi.web.security.knox.KnoxService;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class KnoxAuthenticationProvider
extends NiFiAuthenticationProvider {
    private static final Logger logger = LoggerFactory.getLogger(KnoxAuthenticationProvider.class);
    private final KnoxService knoxService;

    public KnoxAuthenticationProvider(KnoxService knoxService, NiFiProperties nifiProperties, Authorizer authorizer) {
        super(nifiProperties, authorizer);
        this.knoxService = knoxService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        KnoxAuthenticationRequestToken request = (KnoxAuthenticationRequestToken)authentication;
        try {
            String jwtPrincipal = this.knoxService.getAuthenticationFromToken(request.getToken());
            String mappedIdentity = this.mapIdentity(jwtPrincipal);
            StandardNiFiUser user = new StandardNiFiUser.Builder().identity(mappedIdentity).groups(this.getUserGroups(mappedIdentity)).clientAddress(request.getClientAddress()).build();
            return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails((NiFiUser)user));
        }
        catch (JOSEException | ParseException e) {
            logger.info("Unable to validate the access token: " + e.getMessage(), e);
            throw new InvalidAuthenticationException("Unable to validate the access token.", e);
        }
    }

    public boolean supports(Class<?> authentication) {
        return KnoxAuthenticationRequestToken.class.isAssignableFrom(authentication);
    }
}

