/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.converter;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.admin.service.IdpUserGroupService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.authorization.user.StandardNiFiUser;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.authorization.util.UserGroupUtil;
import org.apache.nifi.idp.IdpUserGroup;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jwt.Jwt;

public class StandardJwtAuthenticationConverter
implements Converter<Jwt, NiFiAuthenticationToken> {
    private final Authorizer authorizer;
    private final IdpUserGroupService idpUserGroupService;
    private final List<IdentityMapping> identityMappings;

    public StandardJwtAuthenticationConverter(Authorizer authorizer, IdpUserGroupService idpUserGroupService, NiFiProperties properties) {
        this.authorizer = authorizer;
        this.idpUserGroupService = idpUserGroupService;
        this.identityMappings = IdentityMappingUtil.getIdentityMappings((NiFiProperties)properties);
    }

    public NiFiAuthenticationToken convert(Jwt jwt) {
        NiFiUser user = this.getUser(jwt);
        return new NiFiAuthenticationToken((UserDetails)new NiFiUserDetails(user));
    }

    private NiFiUser getUser(Jwt jwt) {
        String identity = IdentityMappingUtil.mapIdentity((String)jwt.getSubject(), this.identityMappings);
        return new StandardNiFiUser.Builder().identity(identity).groups(UserGroupUtil.getUserGroups((Authorizer)this.authorizer, (String)identity)).identityProviderGroups(this.getIdentityProviderGroups(identity)).build();
    }

    private Set<String> getIdentityProviderGroups(String identity) {
        return this.idpUserGroupService.getUserGroups(identity).stream().map(IdpUserGroup::getGroupName).collect(Collectors.toSet());
    }
}

