/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.vault.hashicorp.config;

import java.io.IOException;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.vault.hashicorp.HashiCorpVaultConfigurationException;
import org.apache.nifi.vault.hashicorp.config.HashiCorpVaultApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.vault.client.RestTemplateFactory;
import org.springframework.vault.config.EnvironmentVaultConfiguration;
import org.springframework.vault.support.ClientOptions;
import org.springframework.vault.support.SslConfiguration;

public class HashiCorpVaultConfiguration
extends EnvironmentVaultConfiguration {
    private static final String HTTPS = "https";
    private final SslConfiguration sslConfiguration;
    private final ClientOptions clientOptions;

    public HashiCorpVaultConfiguration(PropertySource<?> ... propertySources) {
        StandardEnvironment env = new StandardEnvironment();
        for (PropertySource<?> propertySource : propertySources) {
            env.getPropertySources().addFirst(propertySource);
        }
        if (env.containsProperty(VaultConfigurationKey.AUTHENTICATION_PROPERTIES_FILE.key)) {
            String authPropertiesFilename = env.getProperty(VaultConfigurationKey.AUTHENTICATION_PROPERTIES_FILE.key);
            try {
                PropertySource<?> authPropertiesSource = HashiCorpVaultConfiguration.createPropertiesFileSource(authPropertiesFilename);
                env.getPropertySources().addFirst(authPropertiesSource);
            }
            catch (IOException e) {
                throw new HashiCorpVaultConfigurationException("Could not load HashiCorp Vault authentication properties " + authPropertiesFilename, e);
            }
        }
        this.setApplicationContext((ApplicationContext)new HashiCorpVaultApplicationContext((ConfigurableEnvironment)env));
        this.sslConfiguration = env.getProperty(VaultConfigurationKey.URI.key).contains(HTTPS) ? super.sslConfiguration() : SslConfiguration.unconfigured();
        this.clientOptions = this.getClientOptions();
    }

    public static PropertySource<?> createPropertiesFileSource(String filename) throws IOException {
        return new ResourcePropertySource((Resource)new FileSystemResource(Paths.get(filename, new String[0])));
    }

    public ClientOptions clientOptions() {
        return this.clientOptions;
    }

    protected RestTemplateFactory getRestTemplateFactory() {
        return this.restTemplateFactory(this.clientHttpRequestFactoryWrapper());
    }

    public SslConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    private ClientOptions getClientOptions() {
        String configuredConnectionTimeout;
        ClientOptions clientOptions = new ClientOptions();
        Duration readTimeoutDuration = clientOptions.getReadTimeout();
        Duration connectionTimeoutDuration = clientOptions.getConnectionTimeout();
        String configuredReadTimeout = this.getEnvironment().getProperty(VaultConfigurationKey.READ_TIMEOUT.key);
        if (configuredReadTimeout != null) {
            readTimeoutDuration = HashiCorpVaultConfiguration.getDuration(configuredReadTimeout);
        }
        if ((configuredConnectionTimeout = this.getEnvironment().getProperty(VaultConfigurationKey.CONNECTION_TIMEOUT.key)) != null) {
            connectionTimeoutDuration = HashiCorpVaultConfiguration.getDuration(configuredConnectionTimeout);
        }
        return new ClientOptions(connectionTimeoutDuration, readTimeoutDuration);
    }

    private static Duration getDuration(String formattedDuration) {
        double duration = FormatUtils.getPreciseTimeDuration((String)formattedDuration, (TimeUnit)TimeUnit.MILLISECONDS);
        return Duration.ofMillis(Double.valueOf(duration).longValue());
    }

    public static enum VaultConfigurationKey {
        AUTHENTICATION_PROPERTIES_FILE("vault.authentication.properties.file"),
        READ_TIMEOUT("vault.read.timeout"),
        CONNECTION_TIMEOUT("vault.connection.timeout"),
        URI("vault.uri");

        private final String key;

        private VaultConfigurationKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

