/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.net.Proxy;
import java.util.Collection;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

public class HTTPUtils {
    public static final String HTTP_REQUEST_URI = "http.request.uri";
    public static final String HTTP_REMOTE_HOST = "http.remote.host";
    public static final String HTTP_LOCAL_NAME = "http.local.name";
    public static final String HTTP_PORT = "http.server.port";
    public static final String HTTP_SSL_CERT = "http.subject.dn";
    public static final String HTTP_CONTEXT_ID = "http.context.identifier";
    public static final PropertyDescriptor PROXY_HOST = new PropertyDescriptor.Builder().name("Proxy Host").description("The fully qualified hostname or IP address of the proxy server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROXY_PORT = new PropertyDescriptor.Builder().name("Proxy Port").description("The port of the proxy server").required(false).addValidator(StandardValidators.PORT_VALIDATOR).build();
    private static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH};
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((boolean)true, (ProxySpec[])PROXY_SPECS);

    public static String getURI(Map<String, String> map) {
        String client = map.get(HTTP_REMOTE_HOST);
        String server = map.get(HTTP_LOCAL_NAME);
        String port = map.get(HTTP_PORT);
        String uri = map.get(HTTP_REQUEST_URI);
        if (map.get(HTTP_SSL_CERT) == null) {
            return "http://" + client + "@" + server + ":" + port + uri;
        }
        return "https://" + client + "@" + server + ":" + port + uri;
    }

    public static void setProxy(ProcessContext context, HttpClientBuilder clientBuilder, CredentialsProvider credentialsProvider) {
        ProxyConfiguration proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)context, () -> {
            if (context.getProperty(PROXY_HOST).isSet() && context.getProperty(PROXY_PORT).isSet()) {
                ProxyConfiguration componentProxyConfig = new ProxyConfiguration();
                String host = context.getProperty(PROXY_HOST).getValue();
                int port = context.getProperty(PROXY_PORT).asInteger();
                componentProxyConfig.setProxyType(Proxy.Type.HTTP);
                componentProxyConfig.setProxyServerHost(host);
                componentProxyConfig.setProxyServerPort(Integer.valueOf(port));
                return componentProxyConfig;
            }
            return ProxyConfiguration.DIRECT_CONFIGURATION;
        });
        if (Proxy.Type.HTTP.equals((Object)proxyConfig.getProxyType())) {
            String host = proxyConfig.getProxyServerHost();
            int port = proxyConfig.getProxyServerPort();
            clientBuilder.setProxy(new HttpHost(host, port));
            if (proxyConfig.hasCredential()) {
                AuthScope proxyAuthScope = new AuthScope(host, port);
                UsernamePasswordCredentials proxyCredential = new UsernamePasswordCredentials(proxyConfig.getProxyUserName(), proxyConfig.getProxyUserPassword());
                credentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyCredential);
            }
        }
    }

    public static void validateProxyProperties(ValidationContext context, Collection<ValidationResult> results) {
        if (context.getProperty(PROXY_HOST).isSet() && !context.getProperty(PROXY_PORT).isSet()) {
            results.add(new ValidationResult.Builder().explanation("Proxy Host was set but no Proxy Port was specified").valid(false).subject("Proxy server configuration").build());
        }
        ProxyConfiguration.validateProxySpec((ValidationContext)context, results, (ProxySpec[])PROXY_SPECS);
    }
}

