/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.ftp.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;

public class FtpCommandHELP
extends AbstractCommand {
    private static Map<String, String> COMMAND_SPECIFIC_HELP;
    private static int MAX_NUMBER_OF_COMMANDS_IN_A_ROW;
    private Set<String> availableCommands = new TreeSet<String>();

    public void addCommand(String command) {
        if (!command.startsWith("SITE_")) {
            this.availableCommands.add(command);
        }
    }

    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) {
        session.resetState();
        if (!request.hasArgument()) {
            this.sendDefaultHelpMessage(session);
        } else {
            this.handleRequestWithArgument(session, request);
        }
    }

    private void sendDefaultHelpMessage(FtpIoSession session) {
        this.sendCustomHelpMessage(session, this.getDefaultHelpMessage());
    }

    private String getDefaultHelpMessage() {
        StringBuffer helpMessage = new StringBuffer("The following commands are supported.\n");
        int currentNumberOfCommandsInARow = 0;
        Iterator<String> iterator = this.availableCommands.iterator();
        while (iterator.hasNext()) {
            String command = iterator.next();
            if (currentNumberOfCommandsInARow == MAX_NUMBER_OF_COMMANDS_IN_A_ROW) {
                helpMessage.append("\n");
                currentNumberOfCommandsInARow = 0;
            }
            if (iterator.hasNext()) {
                helpMessage.append(command + ", ");
            } else {
                helpMessage.append(command);
            }
            ++currentNumberOfCommandsInARow;
        }
        helpMessage.append("\nEnd of help.");
        return helpMessage.toString();
    }

    private void sendCustomHelpMessage(FtpIoSession session, String message) {
        session.write((Object)new DefaultFtpReply(214, message));
    }

    private void handleRequestWithArgument(FtpIoSession session, FtpRequest request) {
        String ftpCommand = request.getArgument().toUpperCase();
        String commandSpecificHelp = null;
        if (this.availableCommands.contains(ftpCommand)) {
            commandSpecificHelp = COMMAND_SPECIFIC_HELP.get(ftpCommand);
        }
        if (commandSpecificHelp == null) {
            this.sendDefaultHelpMessage(session);
        } else {
            this.sendCustomHelpMessage(session, commandSpecificHelp);
        }
    }

    static {
        MAX_NUMBER_OF_COMMANDS_IN_A_ROW = 5;
        HashMap<String, String> commands = new HashMap<String, String>();
        commands.put("ABOR", "Syntax: ABOR");
        commands.put("APPE", "Syntax: APPE <sp> <pathname>");
        commands.put("AUTH", "Syntax: AUTH <sp> <security_mechanism>");
        commands.put("CDUP", "Syntax: CDUP");
        commands.put("CWD", "Syntax: CWD <sp> <pathname>");
        commands.put("DELE", "Syntax: DELE <sp> <pathname>");
        commands.put("EPRT", "Syntax: EPRT<space><d><net-prt><d><net-addr><d><tcp-port><d>");
        commands.put("EPSV", "Syntax: EPSV");
        commands.put("FEAT", "Syntax: FEAT");
        commands.put("HELP", "Syntax: HELP [<sp> <string>]");
        commands.put("LIST", "Syntax: LIST [<sp> <pathname>]");
        commands.put("MDTM", "Syntax: MDTM <sp> <pathname>");
        commands.put("MKD", "Syntax: MKD <sp> <pathname>");
        commands.put("MLSD", "Syntax: MLSD [<sp> <pathname>]");
        commands.put("MLST", "Syntax: MLST [<sp> <pathname>]");
        commands.put("MODE", "Syntax: MODE <sp> <mode-code>");
        commands.put("NLST", "Syntax: NLST [<sp> <pathname>]");
        commands.put("NOOP", "Syntax: NOOP");
        commands.put("OPTS", "Syntax: OPTS <sp> <options>");
        commands.put("PASS", "Syntax: PASS <sp> <password>");
        commands.put("PASV", "Syntax: PASV");
        commands.put("PBSZ", "Syntax: PBSZ <sp> <buffer_size>");
        commands.put("PORT", "Syntax: PORT <sp> <host-port>");
        commands.put("PROT", "Syntax: PROT <sp> <protection_level>");
        commands.put("PWD", "Syntax: PWD");
        commands.put("QUIT", "Syntax: QUIT");
        commands.put("REIN", "Syntax: REIN");
        commands.put("REST", "Syntax: REST <sp> <marker>");
        commands.put("RETR", "Syntax: RETR <sp> <pathname>");
        commands.put("RMD", "Syntax: RMD <sp> <pathname>");
        commands.put("RNFR", "Syntax: RNFR <sp> <pathname>");
        commands.put("RNTO", "Syntax: RNTO <sp> <pathname>");
        commands.put("SITE", "Syntax: SITE <sp> <string>");
        commands.put("SIZE", "Syntax: SIZE <sp> <pathname>");
        commands.put("STAT", "Syntax: STAT [<sp> <pathname>]");
        commands.put("STOR", "Syntax: STOR <sp> <pathname>");
        commands.put("STOU", "Syntax: STOU");
        commands.put("SYST", "Syntax: SYST");
        commands.put("TYPE", "Syntax: TYPE <sp> <type-code>");
        commands.put("USER", "Syntax: USER <sp> <username>");
        COMMAND_SPECIFIC_HELP = Collections.unmodifiableMap(commands);
    }
}

