/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;

public class Oracle12DatabaseAdapter
implements DatabaseAdapter {
    @Override
    public String getName() {
        return "Oracle 12+";
    }

    @Override
    public String getDescription() {
        return "Generates Oracle compliant SQL for version 12 or greater";
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        return this.getSelectStatement(tableName, columnNames, whereClause, orderByClause, limit, offset, null);
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset, String columnForPartitioning) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder("SELECT ");
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
            if (!StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
                query.append(" AND ");
                query.append(columnForPartitioning);
                query.append(" >= ");
                query.append(offset != null ? offset : "0");
                if (limit != null) {
                    query.append(" AND ");
                    query.append(columnForPartitioning);
                    query.append(" < ");
                    query.append((offset == null ? 0L : offset) + limit);
                }
            }
        }
        if (!StringUtils.isEmpty((CharSequence)orderByClause) && StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (StringUtils.isEmpty((CharSequence)columnForPartitioning)) {
            if (offset != null && offset > 0L) {
                query.append(" OFFSET ");
                query.append(offset);
                query.append(" ROWS");
            }
            if (limit != null) {
                query.append(" FETCH NEXT ");
                query.append(limit);
                query.append(" ROWS ONLY");
            }
        }
        return query.toString();
    }

    @Override
    public String getTableAliasClause(String tableName) {
        return tableName;
    }

    @Override
    public boolean supportsUpsert() {
        return true;
    }

    @Override
    public String getUpsertStatement(String table, List<String> columnNames, Collection<String> uniqueKeyColumnNames) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)table)) {
            throw new IllegalArgumentException("Table name cannot be null or blank");
        }
        if (columnNames == null || columnNames.isEmpty()) {
            throw new IllegalArgumentException("Column names cannot be null or empty");
        }
        if (uniqueKeyColumnNames == null || uniqueKeyColumnNames.isEmpty()) {
            throw new IllegalArgumentException("Key column names cannot be null or empty");
        }
        String newValuesAlias = "n";
        String columns = columnNames.stream().collect(Collectors.joining(", ? "));
        columns = "? " + columns;
        List<String> columnsAssignment = this.getColumnsAssignment(columnNames, newValuesAlias, table);
        List<String> conflictColumnsClause = this.getConflictColumnsClause(uniqueKeyColumnNames, columnsAssignment, table, newValuesAlias);
        String conflictClause = "(" + conflictColumnsClause.stream().collect(Collectors.joining(" AND ")) + ")";
        String insertStatement = columnNames.stream().collect(Collectors.joining(", "));
        String insertValues = newValuesAlias + "." + columnNames.stream().collect(Collectors.joining(", " + newValuesAlias + "."));
        columnsAssignment.removeAll(conflictColumnsClause);
        String updateStatement = columnsAssignment.stream().collect(Collectors.joining(", "));
        StringBuilder statementStringBuilder = new StringBuilder("MERGE INTO ").append(table).append(" USING (SELECT ").append(columns).append(" FROM DUAL) ").append(newValuesAlias).append(" ON ").append(conflictClause).append(" WHEN NOT MATCHED THEN INSERT (").append(insertStatement).append(") VALUES (").append(insertValues).append(")").append(" WHEN MATCHED THEN UPDATE SET ").append(updateStatement);
        return statementStringBuilder.toString();
    }

    private List<String> getConflictColumnsClause(Collection<String> uniqueKeyColumnNames, List<String> conflictColumns, String table, String newTableAlias) {
        List<String> conflictColumnsClause = conflictColumns.stream().filter(column -> uniqueKeyColumnNames.stream().anyMatch(uniqueKey -> column.equalsIgnoreCase(this.getColumnAssignment(table, (String)uniqueKey, newTableAlias)))).collect(Collectors.toList());
        if (conflictColumnsClause.isEmpty()) {
            conflictColumnsClause = conflictColumns.stream().filter(column -> uniqueKeyColumnNames.stream().anyMatch(uniqueKey -> this.normalizeColumnName((String)column).equalsIgnoreCase(this.normalizeColumnName(this.getColumnAssignment(table, (String)uniqueKey, newTableAlias))))).collect(Collectors.toList());
        }
        return conflictColumnsClause;
    }

    private String normalizeColumnName(String colName) {
        return colName == null ? null : colName.toUpperCase().replace("_", "");
    }

    private List<String> getColumnsAssignment(Collection<String> columnsNames, String newTableAlias, String table) {
        ArrayList<String> conflictClause = new ArrayList<String>();
        for (String columnName : columnsNames) {
            StringBuilder statementStringBuilder = new StringBuilder();
            statementStringBuilder.append(this.getColumnAssignment(table, columnName, newTableAlias));
            conflictClause.add(statementStringBuilder.toString());
        }
        return conflictClause;
    }

    private String getColumnAssignment(String table, String columnName, String newTableAlias) {
        return table + "." + columnName + " = " + newTableAlias + "." + columnName;
    }
}

