/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.JoinEnrichment;
import org.apache.nifi.processors.standard.enrichment.EnrichmentRole;

@SupportsBatching
@SideEffectFree
@SeeAlso(value={JoinEnrichment.class})
@WritesAttributes(value={@WritesAttribute(attribute="enrichment.group.id", description="The Group ID to use in order to correlate the 'original' FlowFile with the 'enrichment' FlowFile."), @WritesAttribute(attribute="enrichment.role", description="The role to use for enrichment. This will either be ORIGINAL or ENRICHMENT.")})
@CapabilityDescription(value="Used in conjunction with the JoinEnrichment processor, this processor is responsible for adding the attributes that are necessary for the JoinEnrichment processor to perform its function. Each incoming FlowFile will be cloned. The original FlowFile will have appropriate attributes added and then be transferred to the 'original' relationship. The clone will have appropriate attributes added and then be routed to the 'enrichment' relationship. See the documentation for the JoinEnrichment processor (and especially its Additional Details) for more information on how these Processors work together and how to perform enrichment tasks in NiFi by using these Processors.")
@Tags(value={"fork", "join", "enrich", "record"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class ForkEnrichment
extends AbstractProcessor {
    static final String ENRICHMENT_ROLE = "enrichment.role";
    static final String ENRICHMENT_GROUP_ID = "enrichment.group.id";
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The incoming FlowFile will be routed to this relationship, after adding appropriate attributes.").build();
    static final Relationship REL_ENRICHMENT = new Relationship.Builder().name("enrichment").description("A clone of the incoming FlowFile will be routed to this relationship, after adding appropriate attributes.").build();
    private static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_ORIGINAL, REL_ENRICHMENT)));

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile original = session.get();
        if (original == null) {
            return;
        }
        String groupId = UUID.randomUUID().toString();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ENRICHMENT_GROUP_ID, groupId);
        attributes.put(ENRICHMENT_ROLE, EnrichmentRole.ORIGINAL.name());
        original = session.putAllAttributes(original, attributes);
        attributes.put(ENRICHMENT_ROLE, EnrichmentRole.ENRICHMENT.name());
        FlowFile enrichment = session.clone(original);
        enrichment = session.putAllAttributes(enrichment, attributes);
        session.transfer(original, REL_ORIGINAL);
        session.transfer(enrichment, REL_ENRICHMENT);
    }
}

