/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.behavior.SystemResourceConsiderations;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.standard.xml.DocumentTypeAllowedDocumentProvider;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.apache.nifi.xml.processing.transform.StandardTransformProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"XML", "evaluate", "XPath"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Evaluates one or more XPaths against the content of a FlowFile. The results of those XPaths are assigned to FlowFile Attributes or are written to the content of the FlowFile itself, depending on configuration of the Processor. XPaths are entered by adding user-defined properties; the name of the property maps to the Attribute Name into which the result will be placed (if the Destination is flowfile-attribute; otherwise, the property name is ignored). The value of the property must be a valid XPath expression. If the XPath evaluates to more than one node and the Return Type is set to 'nodeset' (either directly, or via 'auto-detect' with a Destination of 'flowfile-content'), the FlowFile will be unmodified and will be routed to failure. If the XPath does not evaluate to a Node, the FlowFile will be routed to 'unmatched' without having its contents modified. If Destination is flowfile-attribute and the expression matches nothing, attributes will be created with empty strings as the value, and the FlowFile will always be routed to 'matched'")
@WritesAttribute(attribute="user-defined", description="This processor adds user-defined attributes if the <Destination> property is set to flowfile-attribute.")
@DynamicProperty(name="A FlowFile attribute(if <Destination> is set to 'flowfile-attribute'", value="An XPath expression", description="If <Destination>='flowfile-attribute' then the FlowFile attribute is set to the result of the XPath Expression.  If <Destination>='flowfile-content' then the FlowFile content is set to the result of the XPath Expression.")
@SystemResourceConsiderations(value={@SystemResourceConsideration(resource=SystemResource.MEMORY, description="Processing requires reading the entire FlowFile into memory")})
public class EvaluateXPath
extends AbstractProcessor {
    public static final String DESTINATION_ATTRIBUTE = "flowfile-attribute";
    public static final String DESTINATION_CONTENT = "flowfile-content";
    public static final String RETURN_TYPE_AUTO = "auto-detect";
    public static final String RETURN_TYPE_NODESET = "nodeset";
    public static final String RETURN_TYPE_STRING = "string";
    public static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("Destination").description("Indicates whether the results of the XPath evaluation are written to the FlowFile content or a FlowFile attribute; if using attribute, must specify the Attribute Name property. If set to flowfile-content, only one XPath may be specified, and the property name is ignored.").required(true).allowableValues(new String[]{"flowfile-content", "flowfile-attribute"}).defaultValue("flowfile-content").build();
    public static final PropertyDescriptor RETURN_TYPE = new PropertyDescriptor.Builder().name("Return Type").description("Indicates the desired return type of the Xpath expressions.  Selecting 'auto-detect' will set the return type to 'nodeset' for a Destination of 'flowfile-content', and 'string' for a Destination of 'flowfile-attribute'.").required(true).allowableValues(new String[]{"auto-detect", "nodeset", "string"}).defaultValue("auto-detect").build();
    public static final PropertyDescriptor VALIDATE_DTD = new PropertyDescriptor.Builder().name("Validate DTD").description("Specifies whether or not the XML content should be validated against the DTD.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final Relationship REL_MATCH = new Relationship.Builder().name("matched").description("FlowFiles are routed to this relationship when the XPath is successfully evaluated and the FlowFile is modified as a result").build();
    public static final Relationship REL_NO_MATCH = new Relationship.Builder().name("unmatched").description("FlowFiles are routed to this relationship when the XPath does not match the content of the FlowFile and the Destination is set to flowfile-content").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to this relationship when the XPath cannot be evaluated against the content of the FlowFile; for instance, if the FlowFile is not valid XML, or if the Return Type is 'nodeset' and the XPath evaluates to multiple nodes").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private final AtomicReference<XPathFactory> factoryRef = new AtomicReference();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_MATCH);
        relationships.add(REL_NO_MATCH);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(DESTINATION);
        properties.add(RETURN_TYPE);
        properties.add(VALIDATE_DTD);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(context));
        String destination = context.getProperty(DESTINATION).getValue();
        if (DESTINATION_CONTENT.equals(destination)) {
            int xpathCount = 0;
            for (PropertyDescriptor desc : context.getProperties().keySet()) {
                if (!desc.isDynamic()) continue;
                ++xpathCount;
            }
            if (xpathCount != 1) {
                results.add(new ValidationResult.Builder().subject("XPaths").valid(false).explanation("Exactly one XPath must be set if using destination of flowfile-content").build());
            }
        }
        return results;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnScheduled
    public void initializeXPathFactory() {
        this.factoryRef.set((XPathFactory)new XPathFactoryImpl());
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).expressionLanguageSupported(ExpressionLanguageScope.NONE).addValidator((Validator)new XPathValidator()).required(false).dynamic(true).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        QName returnType;
        List flowFiles = session.get(50);
        if (flowFiles.isEmpty()) {
            return;
        }
        ComponentLog logger = this.getLogger();
        XPathFactory factory = this.factoryRef.get();
        XPathEvaluator xpathEvaluator = (XPathEvaluator)factory.newXPath();
        HashMap<String, Object> attributeToXPathMap = new HashMap<String, Object>();
        for (Map.Entry entry : context.getProperties().entrySet()) {
            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
            try {
                Object xpathExpression = xpathEvaluator.compile((String)entry.getValue());
                attributeToXPathMap.put(((PropertyDescriptor)entry.getKey()).getName(), xpathExpression);
            }
            catch (XPathExpressionException e) {
                throw new ProcessException((Throwable)e);
            }
        }
        String destination = context.getProperty(DESTINATION).getValue();
        switch (context.getProperty(RETURN_TYPE).getValue()) {
            case "auto-detect": {
                if (DESTINATION_ATTRIBUTE.equals(destination)) {
                    returnType = XPathConstants.STRING;
                    break;
                }
                if (DESTINATION_CONTENT.equals(destination)) {
                    returnType = XPathConstants.NODESET;
                    break;
                }
                throw new IllegalStateException("The only possible destinations should be CONTENT or ATTRIBUTE...");
            }
            case "nodeset": {
                returnType = XPathConstants.NODESET;
                break;
            }
            case "string": {
                returnType = XPathConstants.STRING;
                break;
            }
            default: {
                throw new IllegalStateException("There are no other return types...");
            }
        }
        boolean validatingDeclaration = context.getProperty(VALIDATE_DTD).asBoolean();
        StandardTransformProvider transformProvider = new StandardTransformProvider();
        transformProvider.setIndent(true);
        block19: for (FlowFile flowFile : flowFiles) {
            AtomicReference<Object> error = new AtomicReference<Object>(null);
            AtomicReference<Object> sourceRef = new AtomicReference<Object>(null);
            try {
                session.read(flowFile, rawIn -> {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        DocumentTypeAllowedDocumentProvider documentProvider = validatingDeclaration ? new DocumentTypeAllowedDocumentProvider() : new StandardDocumentProvider();
                        Document document = documentProvider.parse(in);
                        sourceRef.set(new DOMSource(document));
                    }
                });
            }
            catch (Exception e) {
                logger.error("Input parsing failed {}", new Object[]{flowFile, e});
                session.transfer(flowFile, REL_FAILURE);
                continue;
            }
            HashMap xpathResults = new HashMap();
            for (Map.Entry entry : attributeToXPathMap.entrySet()) {
                Object result;
                try {
                    result = ((XPathExpression)entry.getValue()).evaluate((Object)sourceRef.get(), returnType);
                    if (result == null) {
                        continue;
                    }
                }
                catch (XPathExpressionException e) {
                    logger.error("XPath Property [{}] evaluation on {} failed", new Object[]{flowFile, entry.getKey(), e});
                    session.transfer(flowFile, REL_FAILURE);
                    continue block19;
                }
                if (returnType == XPathConstants.NODESET) {
                    NodeList nodeList = (NodeList)result;
                    if (nodeList.getLength() == 0) {
                        logger.info("XPath evaluation on {} produced no results", new Object[]{flowFile});
                        session.transfer(flowFile, REL_NO_MATCH);
                        continue block19;
                    }
                    if (nodeList.getLength() > 1) {
                        logger.error("XPath evaluation on {} produced unexpected results [{}]", new Object[]{flowFile, nodeList.getLength()});
                        session.transfer(flowFile, REL_FAILURE);
                        continue block19;
                    }
                    Node firstNode = nodeList.item(0);
                    DOMSource sourceNode = new DOMSource(firstNode);
                    if (DESTINATION_ATTRIBUTE.equals(destination)) {
                        try {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            StreamResult streamResult = new StreamResult(baos);
                            transformProvider.transform((Source)sourceNode, (Result)streamResult);
                            xpathResults.put(entry.getKey(), new String(baos.toByteArray(), StandardCharsets.UTF_8));
                        }
                        catch (ProcessingException e) {
                            error.set(e);
                        }
                        continue;
                    }
                    if (!DESTINATION_CONTENT.equals(destination)) continue;
                    flowFile = session.write(flowFile, rawOut -> {
                        try (BufferedOutputStream out = new BufferedOutputStream(rawOut);){
                            StreamResult streamResult = new StreamResult(out);
                            transformProvider.transform(sourceNode, (Result)streamResult);
                        }
                        catch (ProcessingException e) {
                            error.set(e);
                        }
                    });
                    continue;
                }
                String resultString = (String)result;
                if (DESTINATION_ATTRIBUTE.equals(destination)) {
                    xpathResults.put(entry.getKey(), resultString);
                    continue;
                }
                if (!DESTINATION_CONTENT.equals(destination)) continue;
                flowFile = session.write(flowFile, rawOut -> {
                    try (BufferedOutputStream out = new BufferedOutputStream(rawOut);){
                        ((OutputStream)out).write(resultString.getBytes(StandardCharsets.UTF_8));
                    }
                });
            }
            if (error.get() == null) {
                if (DESTINATION_ATTRIBUTE.equals(destination)) {
                    flowFile = session.putAllAttributes(flowFile, xpathResults);
                    Relationship destRel = xpathResults.isEmpty() ? REL_NO_MATCH : REL_MATCH;
                    logger.info("XPath evaluation on {} completed with results [{}]: content updated", new Object[]{flowFile, xpathResults.size()});
                    session.transfer(flowFile, destRel);
                    session.getProvenanceReporter().modifyAttributes(flowFile);
                    continue;
                }
                if (!DESTINATION_CONTENT.equals(destination)) continue;
                logger.info("XPath evaluation on {} completed: content updated", new Object[]{flowFile});
                session.transfer(flowFile, REL_MATCH);
                session.getProvenanceReporter().modifyContent(flowFile);
                continue;
            }
            logger.error("XPath evaluation on {} failed", new Object[]{flowFile, error.get()});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private static class XPathValidator
    implements Validator {
        private XPathValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext validationContext) {
            try {
                XPathFactoryImpl factory = new XPathFactoryImpl();
                XPathEvaluator evaluator = (XPathEvaluator)factory.newXPath();
                String error = null;
                try {
                    evaluator.compile(input);
                }
                catch (Exception e) {
                    error = e.toString();
                }
                return new ValidationResult.Builder().input(input).subject(subject).valid(error == null).explanation(error).build();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().input(input).subject(subject).valid(false).explanation("Unable to initialize XPath engine due to " + e).build();
            }
        }
    }
}

